//
//  YHAutoTextView.swift
//  galaxy
//
//  Created by Dufet on 2024/11/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAutoTextView: UITextView, UITextViewDelegate {
    
    private var calculateHeight: CGFloat = 0.0
    
    var isShowKeyboard: Bool = false {
        didSet {
            if !isShowKeyboard {
                self.snp.updateConstraints { make in
                    make.top.equalTo(5)
                    make.height.equalTo(36)
                    make.bottom.equalTo(-5)
                }
               
            } else {
                
                var realHeight = self.calculateHeight
                if self.calculateHeight > maxHeight {
                    realHeight = maxHeight
                    self.snp.updateConstraints { make in
                        make.top.equalTo(11)
                        make.height.equalTo(realHeight)
                        make.bottom.equalTo(-11)
                    }
                } else {
                    self.snp.updateConstraints { make in
                        make.top.equalTo(11-Self.verticalGap)
                        make.height.equalTo(realHeight)
                        make.bottom.equalTo(-(11-Self.verticalGap))
                    }
                }
            }
            
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    var textChange: ((String) -> Void)?
    
    override open var text: String! {
        didSet {
            textViewDidChange(self)
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }

    let maxHeight = 80.0
    static let verticalGap = 5.0
    var placeHolder: String = "" {
        didSet {
            placeholderLabel.text = placeHolder
        }
    }

    lazy var placeholderLabel: UILabel = {
        let label = UILabel()
        label.translatesAutoresizingMaskIntoConstraints = false
        label.textColor = UIColor.init(hex: 0xB3C8E9)
        label.font = UIFont.PFSC_R(ofSize: 14)
        return label
    }()
    
    override init(frame: CGRect, textContainer: NSTextContainer?) {
        super.init(frame: frame, textContainer: textContainer)
        self.font = .PFSC_R(ofSize: 14)
        delegate = self
        isScrollEnabled = false // 禁止滚动
        self.addSubview(placeholderLabel)
        
        placeholderLabel.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.left.equalTo(5)
            make.right.equalTo(-5)
        }

    }

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    // UITextViewDelegate 方法
    func textViewDidChange(_ textView: UITextView) {
        // 更新自身的高度
        invalidateIntrinsicContentSize()
        placeholderLabel.isHidden = !textView.text.isEmpty
        textChange?(textView.text)
    }
    
    override var intrinsicContentSize: CGSize {
        // 计算内容的尺寸
        //        var height = self.getHeight(text: self.text, font: self.font!, width: frame.width)
        //        if height < 20.0 {
        //            height = 20.0
        //        }
        //        // 加上textView周边的缝隙
        //        height += 15.0

        let size = sizeThatFits(CGSize(width: frame.width, height: .greatestFiniteMagnitude))
        var height = size.height
        self.calculateHeight = height

        isScrollEnabled = height > maxHeight
        
        if height > maxHeight {
            height = maxHeight
            self.snp.updateConstraints { make in
                make.top.equalTo(11)
                make.height.equalTo(height)
                make.bottom.equalTo(-11)
            }
        } else {
            self.snp.updateConstraints { make in
                make.top.equalTo(11-Self.verticalGap)
                make.height.equalTo(height)
                make.bottom.equalTo(-(11-Self.verticalGap))
            }
        }
        return CGSize(width: size.width, height: height)
    }
    
    func getHeight(text: String, font: UIFont, width: CGFloat) -> CGFloat {
        let size = CGSize.init(width: width, height: CGFloat(MAXFLOAT))
        let dic = [NSAttributedString.Key.font: font]
        let strSize = text.boundingRect(with: size, options: [.usesLineFragmentOrigin], attributes: dic, context: nil).size
        return CGSize(width: strSize.width, height: ceil(strSize.height)).height
    }
}
