//
//  YHMakePlanCell.swift
//  galaxy
//
//  Created by EDY on 2025/3/28.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMakePlanCell: UITableViewCell {
    var actionHandler: ((Int) -> Void)?
    var centerView: UIView!
    var titleLabel: UILabel!
    var mainItemView: UIView!
    var country: String = ""
    var index: Int = 0 {
        didSet {
            if index == 0 {
                noDataView.tipsLabel.text = "您已满足续签至永居服务~"
            } else if index == 1 {
                noDataView.tipsLabel.text = "暂未推荐香港工作相关产品，详情请咨询您的专属顾问"
            } else if index == 2 {
                noDataView.tipsLabel.text = "暂未推荐香港工作相关产品，详情请咨询您的专属顾问"
            } else if index == 3 {
                noDataView.tipsLabel.text = "暂未推荐投资相关产品，详情请咨询您的专属顾问"
            }
        }
    }
    lazy var noDataView: YHEmptyDataView = {
        let view = YHEmptyDataView.createView("您已满足续签至永居服务~", kNoPlanBgName)
        view.frame = CGRect(x: 0, y: 36, width: KScreenWidth - 32, height: 116)
        view.backgroundColor = .clear
        view.isHidden = true
        view.emptyBgImgV.snp.remakeConstraints { make in
            make.top.equalToSuperview().offset(0)
            make.width.height.equalTo(96)
            make.centerX.equalTo(view)
        }
        view.tipsLabel.snp.remakeConstraints { make in
            make.top.equalTo(view.emptyBgImgV.snp.bottom)
            make.left.equalTo(20)
            make.right.equalTo(-20)
        }
        view.tipsLabel.numberOfLines = 2
        return view
    }()
    
    var dataSource: [YHMakePlanMainModel]? {
        didSet {
            updateAllViews()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            view.layer.masksToBounds = true
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-7)
        }
        
        centerView.addSubview(noDataView)
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 15)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(20)
            make.right.equalTo(-18)
        }
        
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(36)
        }
    }
    
    func updateAllViews() {
        mainItemView.removeSubviews()
        if dataSource?.count == 0 {
            noDataView.isHidden = false
            mainItemView.isHidden = true
        } else {
            noDataView.isHidden = true
            mainItemView.isHidden = false
        }
        var y = 0
        for i in 0 ..< (dataSource?.count ?? 0) {
            if i != 0 {
                let line = UIView()
                line.backgroundColor = UIColor.separatorColor
                mainItemView.addSubview(line)
                line.snp.makeConstraints { make in
                    make.left.equalTo(18)
                    make.top.equalTo(y)
                    make.height.equalTo(1)
                    make.right.equalTo(-18)
                }
                y += 1
            }
            let h = 121
            let itemView = YHMakePlanCardView()
            itemView.actionHandler = { product in
                self.actionHandler?(product)
            }
            itemView.configure(with: dataSource?[i] ?? YHMakePlanMainModel())
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.right.equalToSuperview()
                make.top.equalTo(y)
                make.height.equalTo(h)
            }
            y += h
        }
    }
}
