//
//  YHSurveyQuestionType.swift
//  galaxy
//
//  Created by alexzzw on 2025/3/26.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHSurveyQuestionType: String, CaseIterable {
    case hasHKId = "是否香港身份"
    case hasPR = "是否有永居服务"
    case isEmployed = "是否受雇香港"
    case hasHKCompany = "是否有香港公司"
    case isHKCompanyOpen = "香港公司是否运营"
    case isMainlandCompanyToHK = "是否有内地公司业务转到香港"
    case isHKOffice = "是否香港办公室"
    case hkResidence = "在港居住情况"
    case hasChildrenEduPlan = "是否子女在港读书计划"
    case hasHKInsurance = "是否香港保险"
    case hasPRLicense = "是否香港驾照"
    case isHKHolder = "是否香港个户"
    case hkStayRate = "在港逗留频率"
    
    func selections() -> [String] {
        switch self {
        case .hasHKId:
            return ["是", "否"]
        case .hasPR:
            return ["是", "否"]
        case .isEmployed:
            return ["是", "否"]
        case .hasHKCompany:
            return ["是", "否"]
        case .isHKCompanyOpen:
            return ["是", "否"]
        case .isMainlandCompanyToHK:
            return ["是", "否"]
        case .isHKOffice:
            return ["是", "否"]
        case .hkResidence:
            return ["枚举值已购房", "已租房", "考虑购房", "考虑租房", "暂不考虑"]
        case .hasChildrenEduPlan:
            return ["是", "否"]
        case .hasHKInsurance:
            return ["是", "否"]
        case .hasPRLicense:
            return ["是", "否"]
        case .isHKHolder:
            return ["是", "否"]
        case .hkStayRate:
            return ["枚举值长期在港", "每周赴港至少一次", "每月去一次", "每季度去一次", "半年去一次", "超过半年去一次"]
        }
    }
}
