//
//  YHMyLikeViewController.swift
//  galaxy
//
//  Created by EDY on 2024/4/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView

class YHMyLikeViewController: YHBaseViewController {
    let viewModel: YHMyLikeViewModel = YHMyLikeViewModel()
    var tableFootView: YHServiceTableFootView!
    var id = 1
    
    lazy var noDataView: YHEmptyDataView = {
        let view = YHEmptyDataView.createView("暂无数据", kEmptyCommonBgName)
        view.isHidden = true
        return view
    }()
    
    var dataSouce: [YHHomeListModel?] = [] {
        didSet {
            self.tableFootView.items = dataSouce
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        loadData()
    }
}

extension YHMyLikeViewController {
    func loadData() {
        if id == 1 || id == 2 {
            self.viewModel.getList(true, id) {[weak self] _, _ in
                guard let self = self else { return }
                if self.viewModel.arrHomeNewsData?.count == 0 {
                    self.tableFootView.isHidden = true
                    self.noDataView.isHidden = false
                } else {
                    self.tableFootView.isHidden = false
                    self.noDataView.isHidden = true
                }
                self.dataSouce = self.viewModel.arrHomeNewsData ?? []
                if self.viewModel.hasMoreForHomeNews == false {
                    self.tableFootView.myCollectView.es.noticeNoMoreData()
                    self.tableFootView.myCollectView.footer?.alpha = 1
                }
            }
        } else {
            self.viewModel.getList(true, callBackBlock: {[weak self] _, _ in
                guard let self = self else { return }
                if self.viewModel.arrHomeNewsData?.count == 0 {
                    self.tableFootView.isHidden = true
                    self.noDataView.isHidden = false
                } else {
                    self.tableFootView.isHidden = false
                    self.noDataView.isHidden = true
                }
                self.dataSouce = self.viewModel.arrHomeNewsData ?? []
                if self.viewModel.hasMoreForHomeNews == false {
                    self.tableFootView.myCollectView.es.noticeNoMoreData()
                    self.tableFootView.myCollectView.footer?.alpha = 1
                }
            })
        }
    }
    
    func setupUI() {
        gk_navigationBar.isHidden = true
        view.backgroundColor = .white

        tableFootView = {
            let view = YHServiceTableFootView()
            view.moreBlock = {[weak self] in
                guard let self = self else { return }
                if id == 1 || id == 2 {
                    self.viewModel.getList(false, id) {[weak self] _, _ in
                        guard let self = self else { return }
                        DispatchQueue.main.asyncAfter(wallDeadline: .now() + 0.35, execute: {
                            CATransaction.setDisableActions(true)
                            self.dataSouce = self.viewModel.arrHomeNewsData ?? []
                            CATransaction.commit()
                            self.tableFootView.myCollectView.es.stopLoadingMore()
                            if self.viewModel.hasMoreForHomeNews == false {
                                self.tableFootView.myCollectView.es.noticeNoMoreData()
                                self.tableFootView.myCollectView.footer?.alpha = 1
                            }
                        })
                    }
                } else {
                    self.viewModel.getList(false, callBackBlock: {[weak self] _, _ in
                        guard let self = self else { return }
                        DispatchQueue.main.asyncAfter(wallDeadline: .now() + 0.35, execute: {
                            CATransaction.setDisableActions(true)
                            self.dataSouce = self.viewModel.arrHomeNewsData ?? []
                            CATransaction.commit()
                            self.tableFootView.myCollectView.es.stopLoadingMore()
                            if self.viewModel.hasMoreForHomeNews == false {
                                self.tableFootView.myCollectView.es.noticeNoMoreData()
                                self.tableFootView.myCollectView.footer?.alpha = 1
                            }
                        })
                    })
                }
            }
            return view
        }()
        
        view.addSubview(tableFootView)
        tableFootView.snp.makeConstraints { make in
            make.top.bottom.left.right.equalToSuperview()
        }
        
        view.addSubview(noDataView)
        noDataView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview()
            make.width.equalTo(KScreenWidth)
            make.height.equalTo(150)
        }
    }
}

extension YHMyLikeViewController: JXSegmentedListContainerViewListDelegate {
    func listView() -> UIView {
        return view
    }
}
