//
//  YHCircleListModel.swift
//  galaxy
//
//  Created by alexzzw on 2025/9/24.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import SmartCodable

// MARK: - 数据模型
class YHCircleListModel: SmartCodable {
    
    required init() {}
    
    var id: String = ""
    var user_id: String = ""
    var user_name: String = ""
    var user_avatar: String = ""
    var content: String = ""
    var images: [String] = []
    var like_count: Int = 0
    var comment_count: Int = 0
    var is_like: Bool = false
    var create_time: String = ""
    var location: String = ""
    var type: Int = 1
    
    var img_width_cell: CGFloat = 0
    var img_height_cell: CGFloat = 0
    
    func calHeightParam() {
        let screenWidth = KScreenWidth
        let cellWidth = (screenWidth - 47) / 2
        
        var totalHeight: CGFloat = 60 + 20 + 44
        
        if !content.isEmpty {
            let font = UIFont.systemFont(ofSize: 14)
            let maxSize = CGSize(width: cellWidth - 24, height: CGFloat.greatestFiniteMagnitude)
            let textRect = content.boundingRect(
                with: maxSize,
                options: [.usesLineFragmentOrigin, .usesFontLeading],
                attributes: [.font: font],
                context: nil
            )
            totalHeight += ceil(textRect.height) + 12
        }
        
        if !images.isEmpty {
            let imageHeight: CGFloat = 120
            totalHeight += imageHeight + 12
        }
        
        self.img_width_cell = cellWidth
        self.img_height_cell = max(totalHeight, 180)
    }
}
