//
//  YHHomeInfoDetailViewController.swift
//  galaxy
//
//  Created by edy on 2024/7/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView

class YHHomeInfoDetailContainerViewController: YHBaseViewController {
    
    var customTitle: String = ""
    var classifyId: Int = 0

    var isHaveHot: Bool = true // 是否有精品
    lazy var tabTitles: [String] = {
        if isHaveHot {
            return ["最新", "精品"]
        }
        return ["最新"]
    }()
    
    lazy var arrItemVCs: [YHBaseViewController] = {
        let vc1 = YHHomeInfoDetailViewController()
        vc1.isHot = false
        vc1.isShowTab = self.isHaveHot
        vc1.classifyId = self.classifyId
        
        let vc2 = YHHomeInfoDetailViewController()
        vc2.isHot = true
        vc2.isShowTab = self.isHaveHot
        vc2.classifyId = self.classifyId
        
        if isHaveHot {
           return [vc1, vc2]
        }
        return [vc1]
    }()

    lazy var segmentedView: JXSegmentedView = {
       let segmentedView = JXSegmentedView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 44))
        segmentedView.delegate = self
        segmentedView.dataSource = segmentedDataSource
        segmentedView.listContainer = listContainerView

        // 配置指示器
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorWidth = 16
        indicator.indicatorHeight = 2
        indicator.indicatorCornerRadius = 0.0
        indicator.indicatorColor = .brandMainColor
        segmentedView.indicators = [indicator]
        segmentedView.defaultSelectedIndex = 0
        return segmentedView
    }()
    
    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let dataSource = JXSegmentedTitleDataSource()
        dataSource.isItemSpacingAverageEnabled = false
        dataSource.titles = self.tabTitles
        dataSource.titleNormalFont = UIFont.PFSC_R(ofSize: 16)
        dataSource.titleNormalColor = UIColor.init(hex: 0x94A3B8)
        dataSource.titleSelectedFont = UIFont.PFSC_M(ofSize: 16)
        dataSource.titleSelectedColor = .mainTextColor
        dataSource.itemWidth = 32.0
        dataSource.itemSpacing = 22.0
        return dataSource
    }()
    
    // 分类title 所对应的VC
    lazy var listContainerView: JXSegmentedListContainerView! = {
        let view = JXSegmentedListContainerView(dataSource: self, type: .scrollView)
        view.backgroundColor = .clear
        return view
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        self.setupUI()
        
    }
    
    func setupUI() {
        gk_navTitle = customTitle
        self.view.backgroundColor = .white
        self.view.addSubview(self.segmentedView)
        self.view.addSubview(self.listContainerView)
        self.segmentedView.isHidden = !self.isHaveHot
        self.segmentedView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.left.right.equalTo(0)
            make.height.equalTo(44)
        }
        self.listContainerView.snp.makeConstraints { make in
            let gap = isHaveHot ? 44.0+4.0 : 4.0
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar+gap)
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.bottom.equalToSuperview()
        }
    }
}

extension YHHomeInfoDetailContainerViewController: JXSegmentedViewDelegate {
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
        
    }
}

extension YHHomeInfoDetailContainerViewController: JXSegmentedListContainerViewDataSource {
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        if let titleDataSource = segmentedView.dataSource as? JXSegmentedBaseDataSource {
            return titleDataSource.dataSource.count
        }
        return 0
    }

    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        guard let vc = arrItemVCs[index] as? JXSegmentedListContainerViewListDelegate else {
            return YHHomeInfoDetailViewController()
        }
        return vc
    }
}
