//
//  YHLookResignResultStateThreeTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/10/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHLookResignResultStateThreeTableViewCell: UITableViewCell {
    static let cellReuseIdentifier = "YHLookResignResultStateThreeTableViewCell"

    typealias ExperienceListBlock = (_ model: YHResignUploadDocModel, _ section: Int) -> Void
    var clickBlock: ExperienceListBlock?
    var centerView: UIView!
    var flagView: UIView!
    var flagImageView: UIImageView!
    var flagLabel: UILabel!
    var mainItemView: UIView!
    var state: Int = 0
    var dataSource: [YHLookResignResultDataLettersModel]? {
        didSet {
            updateAllViews()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(0)
            make.bottom.equalTo(0)
        }
        
        flagView = {
            let view = UIView()
            view.backgroundColor = UIColor.contentBkgColor
            return view
        }()
        centerView.addSubview(flagView)
        flagView.snp.makeConstraints { make in
            make.left.top.equalTo(12)
            make.right.equalTo(-12)
            make.height.equalTo(44)
        }
        
        flagLabel = {
            let label = UILabel()
            label.textAlignment = .center
            let a = ASAttributedString.init("请查看", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor50))
            let b = ASAttributedString.init("《", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.brandMainColor))
            let c = ASAttributedString.init("领取续签签证指引", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.brandMainColor), .underline(.single), .action {
                // 跳转引导
                let view = YHLookResignGuideLineView.sheetView()
                view.ischeckBeforeFlag = true
                view.show()
            })
            let d = ASAttributedString.init(" 》", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.brandMainColor))
            let e = ASAttributedString.init("根据指引操作", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor50))
            label.attributed.text = a+b+c+d+e
            return label
        }()
        flagView.addSubview(flagLabel)
        flagLabel.snp.makeConstraints { make in
            make.left.equalTo(12)
            make.top.bottom.equalToSuperview()
            make.right.equalTo(-12)
        }
        
        mainItemView = {
            let view = UIView()
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(56)
        }
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        mainItemView.removeSubviews()
        if dataSource.count == 1 {
            let view = YHLookResignResultItemView(frame: .zero)
            view.state = state
            view.dataSource = dataSource.first
            mainItemView.addSubview(view)
            view.snp.makeConstraints { make in
                make.centerX.equalToSuperview()
                make.top.equalTo(20)
                make.width.equalTo(197)
                make.height.equalTo(142)
            }
        } else {
            var count = 0
            for item in dataSource {
                let y: Int = count / 2
                let x: Int = count % 2
                let view = YHLookResignResultItemView(frame: .zero)
                view.state = state
                view.dataSource = item
                mainItemView.addSubview(view)
                view.snp.makeConstraints { make in
                    if x == 0 {
                        make.left.equalTo(20)
                    } else {
                        make.right.equalTo(-20)
                    }
                    make.top.equalTo(y * 116 + 15)
                    make.width.equalTo(140.fix)
                    make.height.equalTo(101)
                }
                count += 1
            }
        }
    }
}
