//
//  YHIncomeType.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

enum YHIncomeType: Int, CaseIterable {
    case incomeOfMainland = 1
    case incomeOfHKCompanies = 2
    case incomeOfMacauCompanies = 3
    case stockOrEquityIncome = 4
    case salaryIncomeAndBonus = 5
    case dividendIncome = 6
    case equityTransferIncome = 7
    case businessIncome = 8
    case incomeOfOtherOverseasCompanies = 9
    
    static func defaultDocs() -> [String] {
        return ["纳税记录",
                "纳税清单",
                "工作证明"]
    }
    
    func nameString() -> String {
        switch self {
        case .incomeOfMainland:
            return "内地公司收入(持股50%及以上)"
        case .incomeOfHKCompanies:
            return "香港公司收入(持股50%及以上)"
        case .incomeOfMacauCompanies:
            return "澳门公司收入(持股50%及以上)"
        case .stockOrEquityIncome:
            return "上市公司股票期权或股权收入"
        case .salaryIncomeAndBonus:
            return "工资薪金所得及全年一次性奖金"
        case .dividendIncome:
            return "持股公司分红收入"
        case .equityTransferIncome:
            return "股权转让收入"
        case .businessIncome:
            return "个体工商户/合伙企业/独资企业经营所得收入"
        case .incomeOfOtherOverseasCompanies:
            return "其他境外公司收入(持股50%及以上)"
        }
    }
    
    func docsArray() -> [String] {
        switch self {
        case .incomeOfMainland:
            return ["验资报告",
                    "审计报告",
                    "绝对实益拥有人声明书",
                    "企业所得税月（季）度预缴纳税申报表（A类）（前4个季度/前12个月）",
                    "企业所得税完税证明（表格式）",
                    "企业所得税年度纳税申报表（A类）（近一年度）",
                    "工作证明"]
        case .incomeOfHKCompanies:
            return ["周年申报表",
                    "审计报告",
                    "利得税申请表",
                    "利得税缴纳通知书",
                    "缴税凭证",
                    "绝对实益拥有人声明书",
                    "工作签证",
                    "工作证明"]
        case .incomeOfMacauCompanies:
            return ["商业登记证明",
                    "审计报告",
                    "所得补充税B组──收益申报书（M1）",
                    "所得补充税—收益评定通知书（M5）",
                    "缴税凭证",
                    "绝对实益拥有人声明书",
                    "工作签证",
                    "工作证明"]
        case .stockOrEquityIncome:
            return ["纳税记录",
                    "纳税清单",
                    "股票或期权的发放证明（能看到个人的发放股数和每股价值）",
                    "工作证明"]
        case .salaryIncomeAndBonus:
            return ["纳税记录",
                    "纳税清单",
                    "工作证明"]
        case .dividendIncome:
            return ["纳税记录",
                    "纳税清单",
                    "持股证明",
                    "股东分红决议",
                    "分红入账记录（银行回单）",
                    "工作证明（持股公司开具）"]
        case .equityTransferIncome:
            return ["纳税记录",
                    "纳税清单",
                    "股权转让相关入账记录（银行回单）",
                    "股权转让协议",
                    "股权交割证明&股权变更登记表（显示公司股权占比更改）",
                    "完税证明（表格式）",
                    "工作证明"]
        case .businessIncome:
            return ["纳税记录",
                    "纳税清单",
                    "个人所得税经营所得纳税申报表（A表）（前4个季度/前12个月）",
                    "个人所得税经营所得纳税申报表（A表&B表）（最新年度）",
                    "个人所得税经营所得纳税申报表（C表）",
                    "工作证明"]
        case .incomeOfOtherOverseasCompanies:
            return ["财务报表",
                    "合法纳税及完税证明",
                    "公司所有权官方证明文件",
                    "工作签证",
                    "工作证明"]
        }
    }
    
}
