//
//  YHWorkItemAddView.swift
//  galaxy
//
//  Created by EDY on 2024/2/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkItemAddView: UIView {

    let btnTitleColor: UIColor = .brandMainColor
    let btnHeight = 44.0
    let cornerRadius = 4.0
    
    var clickBlock: (() -> Void)?
    
    var title: String? {
        didSet {
            addBtn.setTitle(title, for: .normal)
        }
    }
    
    lazy var addBtn: UIButton = {
        let btn = UIButton()
        btn.setTitle("新增信息".local, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
        btn.setTitleColor(btnTitleColor, for: .normal)
        btn.iconInLeft(spacing: 6)
        btn.setImage(UIImage(named: "form_add_info")?.withRenderingMode(.alwaysTemplate), for: .normal)
        btn.tintColor = .brandMainColor
        btn.addTarget(self, action: #selector(didClickAddBtn), for: .touchUpInside)
        return btn
    }()
    
    lazy var dotLineLayer: CAShapeLayer = {
        
        let borderLayer =  CAShapeLayer()
        borderLayer.position = CGPoint(x: addBtn.bounds.midX, y: addBtn.bounds.midY)
        borderLayer.path = UIBezierPath(roundedRect: borderLayer.bounds, cornerRadius: addBtn.layer.cornerRadius).cgPath
        borderLayer.lineWidth = 0.5
        // [数组第一个数字表示单个虚线长度，第二个数字表示间隔]
        borderLayer.lineDashPattern = [2, 2]  as [NSNumber]?
        // 前边是虚线的长度，后边是虚线之间空隙的长度
        borderLayer.lineDashPhase = 0.1
        // 实线边框
        borderLayer.fillColor = UIColor.clear.cgColor
        borderLayer.strokeColor = btnTitleColor.cgColor
        return borderLayer
        
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
   
    func setupUI() {
        
        addSubview(addBtn)
        addBtn.layer.addSublayer(dotLineLayer)

        addBtn.snp.makeConstraints { make in
            make.left.top.equalToSuperview()
            make.right.bottom.equalToSuperview()
        }
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        
        print(addBtn.bounds)
        dotLineLayer.path = UIBezierPath(roundedRect: addBtn.bounds, cornerRadius: cornerRadius).cgPath
    
    }
    
    @objc func didClickAddBtn() {
     
        if let clickBlock = clickBlock {
            clickBlock()
        }
    }
}
