//
//  YHMySignatureListViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/3/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMySignatureListViewModel: YHBaseViewModel {

    var mainModel: YHMySignatureListModel?
    
    override init() {
        super.init()
    }
    
    func requestSignatureList(_ orderId: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["order_id": orderId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.list
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMySignatureListModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.mainModel = result
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
