//
//  YHResignAppointMember.swift
//  galaxy
//
//  Created by edy on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

// [YHResignAppointMember] 数组实现神拷贝
extension Array where Element == YHResignAppointMember {
    
    func deepCopy() -> [YHResignAppointMember] {
        var results: [YHResignAppointMember] = []
        for item in self {
            if let newItem = item.copy() as? YHResignAppointMember {
                results.append(newItem)
            }
        }
        return results
    }
}

class YHResignAppointMember: SmartCodable, NSCopying {
    
    var id: Int = 0
    var renewal_number: Int = 0
    var apply_relation: Int = 0
    var apply_uid: String = ""
    var apply_name: String = ""
    var stay_deadline: String = ""
    var state: String = ""
    var stay_deadline_start: String = ""
    
    // 自定义 是否选中
    var isSelected: Bool = false
    
    required init() {
        
    }
    
    init(id: Int, renewal_number: Int, apply_relation: Int, apply_uid: String, apply_name: String, stay_deadline: String, state: String, stay_deadline_start: String, isSelected: Bool) {
        
        self.id = id
        self.renewal_number = renewal_number
        self.apply_relation = apply_relation
        self.apply_uid = apply_uid
        self.apply_name = apply_name
        self.stay_deadline = stay_deadline
        self.state = state
        self.isSelected = isSelected
        self.stay_deadline_start = stay_deadline_start
    }
    
    func copy(with zone: NSZone? = nil) -> Any {
        
        return YHResignAppointMember(id: self.id, renewal_number: self.renewal_number, apply_relation: self.apply_relation, apply_uid: self.apply_uid, apply_name: self.apply_name, stay_deadline: self.stay_deadline, state: self.state, stay_deadline_start: self.stay_deadline_start, isSelected: self.isSelected)
    }
    
}
