//
//  YHGCWorkExperienceListReasonTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/12/30.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHGCWorkExperienceListReasonTableViewCell: UITableViewCell {
    typealias ExperienceListBlock = (_ value: String) -> Void
    var clickBlock: ExperienceListBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var lineView: UIView!
    var messageLabel: UILabel!
    var messageView: UIView!
    var messageTextField: UITextView!
    var promptsLabel: UILabel!
    var messageNumberLabel: UILabel!

    var model: YHGCWorkModel? {
        didSet {
            if model?.has_work_time_overlap == 1 {
                messageLabel.isHidden = false
                messageView.isHidden = false
                messageTextField.isHidden = false
                promptsLabel.isHidden = false
                messageNumberLabel.isHidden = false
                messageLabel.snp.remakeConstraints { make in
                    make.left.equalTo(18)
                    make.right.equalTo(-18)
                    make.top.equalTo(68)
                }
                messageView.snp.remakeConstraints { make in
                    make.left.equalTo(18)
                    make.right.equalTo(-18)
                    make.top.equalTo(112)
                    make.height.equalTo(160)
                }
                messageTextField.snp.remakeConstraints { make in
                    make.left.equalTo(18)
                    make.right.equalTo(-18)
                    make.top.equalTo(112)
                    make.height.equalTo(128)
                }
                promptsLabel.snp.remakeConstraints { make in
                    make.left.equalTo(22)
                    make.right.equalTo(-22)
                    make.top.equalTo(116)
                }
                messageNumberLabel.snp.remakeConstraints { make in
                    make.right.equalTo(-30)
                    make.top.equalTo(240)
                    make.height.equalTo(20)
                    make.bottom.equalTo(-28)
                }
            }
            messageTextField.text = model?.work_time_overlap_remark
            if messageTextField.text.count != 0 {
                promptsLabel.isHidden = true
                messageNumberLabel.text = "\(messageTextField.text.count)/1000"
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-7)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.text = "工作时间说明"
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.top.equalTo(23)
            make.height.equalTo(24)
            make.right.equalTo(-20)
        }
        
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(52)
            make.height.equalTo(1)
        }
        
        messageLabel = {
            let label = UILabel()
            label.numberOfLines = 0
            let a: ASAttributedString = .init("*", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.failColor))
            let aa: ASAttributedString = .init(" 检测到您的", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor(hex: 0x8893a2)))
            let aaa: ASAttributedString = .init("工作时间有重叠", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.failColor))
            let aaaa: ASAttributedString = .init(" 。请确认是否正确填报，若填报无误请在此处说明工作时间重叠的原因~", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor(hex: 0x8893a2)))
            label.attributed.text = a + aa + aaa + aaaa
            return label
        }()
    
        centerView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(68)
        }
        
        messageView = {
            let view = UIView()
            view.backgroundColor = UIColor.contentBkgColor
            view.layer.cornerRadius = 1
            return view
        }()
        centerView.addSubview(messageView)
        messageView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(112)
            make.height.equalTo(160)
        }
        
        messageTextField = {
            let textField = UITextView()
            textField.font = UIFont.PFSC_R(ofSize: 14)
            textField.backgroundColor = .clear
            textField.delegate = self
            return textField
        }()
        centerView.addSubview(messageTextField)
        messageTextField.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(112)
            make.height.equalTo(128)
        }
    
        promptsLabel = {
            let prompts = UILabel()
            prompts.font = UIFont.PFSC_R(ofSize: 14)
            prompts.textColor = UIColor(hex: 0xc0c0c0)
            prompts.text = "如：工作时间灵活，可自由安排"
            prompts.numberOfLines = 0
            prompts.backgroundColor = .clear
            return prompts
        }()
        centerView.addSubview(promptsLabel)
        promptsLabel.snp.makeConstraints { make in
            make.left.equalTo(22)
            make.right.equalTo(-22)
            make.top.equalTo(116)
        }
        
        messageNumberLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.text = "0/1000"
            label.textAlignment = .right
            label.textColor = UIColor(hex: 0xd5dae1)
            return label
        }()
        centerView.addSubview(messageNumberLabel)
        messageNumberLabel.snp.makeConstraints { make in
            make.right.equalTo(-30)
            make.top.equalTo(240)
            make.height.equalTo(20)
        }
    }
}

extension YHGCWorkExperienceListReasonTableViewCell: UITextViewDelegate {
    func textViewDidChange(_ textView: UITextView) {
        let number = textView.text.count
        if textView.text.count != 0 {
            promptsLabel.isHidden = true
            messageNumberLabel.text = "\(number)/1000"
        } else {
            promptsLabel.isHidden = false
            messageNumberLabel.text = "\(number)/1000"
        }
        if let block = clickBlock {
            block(textView.text)
        }
    }
    
    func textView(_ textView: UITextView, shouldChangeTextIn range: NSRange, replacementText text: String) -> Bool {
        let newLength = (textView.text as NSString).length + text.count - range.length
        return newLength <= 1000
    }
}
