//
//  YHPlanPolicyCarouselImageCell.swift
//  galaxy
//
//  Created by Dufet on 2025/3/27.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import FSPagerView

class YHPlanPolicyCarouselImageCell: FSPagerViewCell {
    
    static let cellReuseIdentifier = "YHPlanPolicyCarouselImageCell"

    var model = YHPlanCaseModel() {
        didSet {
        
            if let url = URL(string: model.img_url) {
                imageV.sd_setImage(with: url, placeholderImage: UIImage(named: "global_default_image"))
            } else {
                imageV.image = UIImage(named: "global_default_image")
            }
        }
    }
    lazy var imageV: UIImageView = {
        let v = UIImageView()
        return v
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func initView() {
        
        self.addSubview(imageV)
        imageV.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
    }
}
