//
//  TUIFoldConversationListDataProvider_Minimalist.m
//  TUIConversation
//
//  Created by wyl on 2022/11/22.
//  Copyright © 2023 Tencent. All rights reserved.
//

#import "TUIFoldConversationListDataProvider_Minimalist.h"
#import <TIMCommon/TIMDefine.h>
#import <TUICore/TUICore.h>
#import "TUIConversationCellData_Minimalist.h"
#import <TIMCommon/NSString+TUIEmoji.h>

@implementation TUIFoldConversationListDataProvider_Minimalist

- (Class)getConversationCellClass {
    return [TUIConversationCellData_Minimalist class];
}

- (NSString *)getDisplayStringFromService:(V2TIMMessage *)msg {
    NSDictionary *param = @{TUICore_TUIChatService_GetDisplayStringMethod_MsgKey : msg};
    return [TUICore callService:TUICore_TUIChatService_Minimalist method:TUICore_TUIChatService_GetDisplayStringMethod param:param];
}
- (NSMutableAttributedString *)getLastDisplayString:(V2TIMConversation *)conv {
    /**
     * If has group-at message, the group-at information will be displayed first
     */
    NSString *atStr = [self getGroupAtTipString:conv];
    NSMutableAttributedString *attributeString = [[NSMutableAttributedString alloc] initWithString:atStr];
    NSDictionary *attributeDict = @{NSForegroundColorAttributeName : [UIColor d_systemRedColor]};
    [attributeString setAttributes:attributeDict range:NSMakeRange(0, attributeString.length)];

    /**
     * If there is a draft box, the draft box information will be displayed first
     */
    if (conv.draftText.length > 0) {
        NSAttributedString *draft = [[NSAttributedString alloc] initWithString:TIMCommonLocalizableString(TUIKitMessageTypeDraftFormat)
                                                                    attributes:@{NSForegroundColorAttributeName : RGB(250, 81, 81)}];
        [attributeString appendAttributedString:draft];

        NSString *draftContentStr = [self getDraftContent:conv];
        draftContentStr = [draftContentStr getLocalizableStringWithFaceContent];
        NSAttributedString *draftContent = [[NSAttributedString alloc] initWithString:draftContentStr
                                                                           attributes:@{NSForegroundColorAttributeName : [UIColor d_systemGrayColor]}];
        [attributeString appendAttributedString:draftContent];
    } else {
        /**
         * No drafts, show conversation lastMsg information
         */
        NSString *lastMsgStr = @"";

        /**
         * Attempt to get externally customized display information
         */
        if (self.delegate && [self.delegate respondsToSelector:@selector(getConversationDisplayString:)]) {
            lastMsgStr = [self.delegate getConversationDisplayString:conv];
        }

        /**
         * If there is no external customization, get the lastMsg display information through the message module
         */
        if (lastMsgStr.length == 0 && conv.lastMessage) {
            lastMsgStr = [self getDisplayStringFromService:conv.lastMessage];
        }

        /**
         * If there is no lastMsg display information and no draft information, return nil directly
         */
        if (lastMsgStr.length == 0) {
            return nil;
        }
        [attributeString appendAttributedString:[[NSAttributedString alloc] initWithString:lastMsgStr]];
    }

    /**
     * If do-not-disturb is set, the message do-not-disturb state is displayed
     * The default state of the meeting type group is V2TIM_RECEIVE_NOT_NOTIFY_MESSAGE, and the UI does not process it.
     */
    if ([self isConversationNotDisturb:conv] && conv.unreadCount > 0) {
        NSAttributedString *unreadString = [[NSAttributedString alloc]
            initWithString:[NSString stringWithFormat:@"[%d %@] ", conv.unreadCount, TIMCommonLocalizableString(TUIKitMessageTypeLastMsgCountFormat)]];
        [attributeString insertAttributedString:unreadString atIndex:0];
    }

    return attributeString;
}

@end
