//
//  SampleHandler.swift
//  yinheReplayExt
//
//  Created by alexzzw on 2025/6/18.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import ReplayKit
import TXLiteAVSDK_ReplayKitExt

let APPGROUP = "group.com.intelligence.galaxy"

class SampleHandler: RPBroadcastSampleHandler, TXReplayKitExtDelegate {
    
    
    override func broadcastStarted(withSetupInfo setupInfo: [String : NSObject]?) {
        // User has requested to start the broadcast. Setup info from the UI extension can be supplied but optional.
        TXReplayKitExt.sharedInstance().setup(withAppGroup: APPGROUP, delegate: self)
    }
    
    override func broadcastPaused() {
        // User has requested to pause the broadcast. Samples will stop being delivered.
    }
    
    override func broadcastResumed() {
        // User has requested to resume the broadcast. Samples delivery will resume.
    }
    
    override func broadcastFinished() {
        // User has requested to finish the broadcast.
        TXReplayKitExt.sharedInstance().broadcastFinished()
    }
    
    func broadcastFinished(_ broadcast: TXReplayKitExt, reason: TXReplayKitExtReason) {
        var tip = ""
        switch reason {
        case TXReplayKitExtReason.requestedByMain:
            tip = "屏幕共享已结束"
            break
        case TXReplayKitExtReason.disconnected:
            tip = "应用断开"
            break
        case TXReplayKitExtReason.versionMismatch:
            tip = "集成错误（SDK 版本号不相符合）"
            break
        default:
            break
        }

        let error = NSError(domain: NSStringFromClass(self.classForCoder), code: 0, userInfo: [NSLocalizedFailureReasonErrorKey:tip])
        finishBroadcastWithError(error)
    }
    
    override func processSampleBuffer(_ sampleBuffer: CMSampleBuffer, with sampleBufferType: RPSampleBufferType) {
        TXReplayKitExt.sharedInstance().send(sampleBuffer, with: sampleBufferType)
//        switch sampleBufferType {
//        case RPSampleBufferType.video:
//            // Handle video sample buffer
//            TXReplayKitExt.sharedInstance().send(sampleBuffer, with: .video)
//            break
//        case RPSampleBufferType.audioApp:
//            // Handle audio sample buffer for app audio
//            break
//        case RPSampleBufferType.audioMic:
//            // Handle audio sample buffer for mic audio
//            break
//        @unknown default:
//            // Handle other sample buffer types
//            fatalError("Unknown type of sample buffer")
//        }
    }
}
