//
//  YHHomeBannerCollectionViewCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import FSPagerView

class YHHomeBannerCollectionViewCell: FSPagerViewCell {
    override init(frame: CGRect) {
        super.init(frame: frame)
        textLabel?.text = ""
        textLabel?.isHidden = true
        imageView?.isHidden = true
        
        initView()
    }
    
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var bannerImagV: UIImageView = {
        let imagV : UIImageView = UIImageView()
        imagV.contentMode = .scaleAspectFill
        imagV.clipsToBounds = true
        imagV.image = UIImage(named: "global_default_image")
        return imagV
    }()
    
    lazy var bannerTitleLable: UILabel = {
        let lable = UILabel()
        lable.font = UIFont.PFSC_R(ofSize: 16)
        lable.textColor = UIColor.white
        return lable
    }()
    
    
    lazy var effectV : UIVisualEffectView = {
        let effect = UIBlurEffect(style: .light)
        let effectV = UIVisualEffectView.init(effect: effect)
        return effectV
    }()
    
    var dataModel : YHBannerModel? {
        didSet {
            updateUI()
        }
    }
}

private extension YHHomeBannerCollectionViewCell {
    func initView() {
        contentView.addSubview(bannerImagV)
        bannerImagV.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        contentView.addSubview(effectV)
        effectV.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(77)
        }
        
        contentView.addSubview(bannerTitleLable)
        bannerTitleLable.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.bottom.equalTo(-35)
            make.left.equalTo(20)
            make.height.equalTo(22)
        }
    }
    
    func updateUI() {
        guard let model = dataModel else { return }
        
        if model.isLocalItemFlag {
            bannerTitleLable.isHidden = true
            effectV.isHidden = true
            
            bannerImagV.image = UIImage(named: model.img_url)
        } else {
            bannerTitleLable.isHidden = false
            effectV.isHidden = false
            
            if let url = URL(string: model.img_url) {
                bannerImagV.kf.setImage(with: url, placeholder: UIImage(named: "global_default_image"))
            } else {
                bannerImagV.image = UIImage(named: "global_default_image")
            }
            bannerTitleLable.text = model.name
        }
    }
}
