//
//  YHHomeHeadView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
class YHHomeHeadView: UIView {
    static let viewH : CGFloat = (20 + YHHomeBannerView.viewH) + (20 + YHHkLifeAndIdView.viewH) + (20 + YHHomeKingKongBlockView.viewH) + 20 + 20
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    //1.bannner
    lazy var homeBannerView : YHHomeBannerView = {
        let view = YHHomeBannerView()
        return view
    }()
    
    //2.香港身份 香港生活
    lazy var homeHkLife : YHHkLifeAndIdView = {
        let view = YHHkLifeAndIdView()
        return view
    }()
    
    //3. 四大金刚区
    lazy var homeKingKongBlock : YHHomeKingKongBlockView = {
        let view = YHHomeKingKongBlockView()
        return view
    }()
}

private extension YHHomeHeadView {
    func initView() {
        backgroundColor = .clear
        
        addSubview(homeBannerView)
        homeBannerView.snp.makeConstraints { make in
            make.top.equalTo(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHHomeBannerView.viewH)
        }
        
        addSubview(homeHkLife)
        homeHkLife.snp.makeConstraints { make in
            make.top.equalTo(homeBannerView.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHHkLifeAndIdView.viewH)
        }
        
        addSubview(homeKingKongBlock)
        homeKingKongBlock.snp.makeConstraints { make in
            make.top.equalTo(homeHkLife.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHHomeKingKongBlockView.viewH)
        }
        
        let line = UIView()
        line.backgroundColor = UIColor(hex: 0xF0F3F7, alpha: 1.0)
        addSubview(line)
        line.snp.makeConstraints { make in
            make.top.equalTo(homeKingKongBlock.snp.bottom).offset(21)
            make.left.right.equalToSuperview()
            make.height.equalTo(1)
        }
    }
}
