//
//  YHSearchInfoHistoryCell.swift
//  galaxy
//
//  Created by edy on 2024/4/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSearchInfoHistoryCell: UICollectionViewCell {
    
    static let cellReuseIdentifier = "YHSearchInfoHistoryCell"
    
    lazy var titleLabel: UILabel =  {
        var label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textAlignment = .left
        label.textColor = UIColor(hex: 0x121A26)
        return label
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }

    private func setupUI() {
        
        contentView.backgroundColor = UIColor(hexString: "#F4F6FA")
        contentView.clipsToBounds = true
        contentView.addSubview(titleLabel)
        
        titleLabel.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(12.0)
            make.right.equalToSuperview().offset(-12.0)
        }
    }
        
}
