//
//  YHOrderDetailViewController.swift
//  galaxy
//
//  Created by EDY on 2024/4/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHOrderDetailViewController: YHBaseViewController {
    var centerView: UIView!
    var titleLabel: UILabel!
    var lineView: UIView!
    var orderLabel: UILabel!
    var orderNumLabel: UILabel!
    var phoneLabel: UILabel!
    var phoneNumLabel: UILabel!
    var copyButton: UIButton!

    
    var model: YHContactItemModel = YHContactItemModel()
    override func viewDidLoad() {
        super.viewDidLoad()
        setView()
        // Do any additional setup after loading the view.
    }

    func setView() {
        gk_navTitle = "我的订单"
        gk_navBackgroundColor = UIColor.white
        gk_navBarAlpha = 1
        
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius8
            view.masksToBounds = true
            return view
        }()
        view.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 16)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(149)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.text = model.productName
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(18)
            make.left.equalTo(16)
            make.height.equalTo(24)
        }
        
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.top.equalTo(54.5)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(1)
        }
        
        orderLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor(hex: 0x121A26).withAlphaComponent(0.5)
            label.text = "合同编号： "
            return label
        }()
        centerView.addSubview(orderLabel)
        orderLabel.snp.makeConstraints { make in
            make.top.equalTo(72.5)
            make.left.equalTo(16)
            make.height.equalTo(20)
        }
        
        phoneLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor(hex: 0x121A26).withAlphaComponent(0.5)
            label.text = "签约手机号："
            return label
        }()
        centerView.addSubview(phoneLabel)
        phoneLabel.snp.makeConstraints { make in
            make.top.equalTo(110.5)
            make.left.equalTo(16)
            make.height.equalTo(20)
        }
        
        orderNumLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor(hex: 0x121A26)
            label.text = model.orderSn
            label.textAlignment = .right
            return label
        }()
        centerView.addSubview(orderNumLabel)
        orderNumLabel.snp.makeConstraints { make in
            make.top.equalTo(72.5)
            make.right.equalTo(-58)
            make.height.equalTo(20)
        }
        
        phoneNumLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor(hex: 0x121A26)
            label.text = model.mobile
            label.textAlignment = .right
            return label
        }()
        centerView.addSubview(phoneNumLabel)
        phoneNumLabel.snp.makeConstraints { make in
            make.top.equalTo(110.5)
            make.right.equalTo(-16)
            make.height.equalTo(20)
        }
        
        copyButton = {
            let button = UIButton(type: .custom)
            button.setTitle("复制", for: .normal)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 13)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.addTarget(self, action: #selector(copyButtonClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(copyButton)
        copyButton.snp.makeConstraints { make in
            make.top.equalTo(72.5)
            make.right.equalTo(-16)
            make.height.equalTo(18)
            make.width.equalTo(26)
        }
        
        let subLineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(subLineView)
        subLineView.snp.makeConstraints { make in
            make.centerY.equalTo(copyButton.snp.centerY)
            make.right.equalTo(-50)
            make.width.equalTo(1)
            make.height.equalTo(6)
        }
    }

    @objc func copyButtonClick() {
        let textToCopy = orderNumLabel.text
        UIPasteboard.general.string = textToCopy
        YHHUD.flash(message: "复制成功")
    }
}
