//
//  YHServiceOrderListView.swift
//  galaxy
//
//  Created by EDY on 2024/4/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView

class YHServiceOrderListView: YHBaseViewController {
    private let viewModel : YHServiceCenterMainViewModel = YHServiceCenterMainViewModel()
    typealias Block = (Int,Int) -> ()
    var block: Block?
    var orderID: Int = 0
    var type: Int = 0
    var mobile: String = ""
    var homeTableView: UITableView!
    private let noDataView : YHNoDataTipsView = {
        let view = YHNoDataTipsView()
        view.isHidden = true
        return view
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        loadData()
    }
    
}

extension YHServiceOrderListView {
    func loadData() {
        if YHLoginManager.shared.isLogin() {
            viewModel.getServiceCenterProgressList(orderID, type) {[weak self] success, error in
                guard let self = self else { return }
                if (self.homeTableView != nil) {
                    if self.viewModel.arrDataForSeviceCenterProgress.count == 0 {
                        self.homeTableView.isHidden = true
                        self.noDataView.isHidden = false
                    } else {
                        self.homeTableView.isHidden = false
                        self.noDataView.isHidden = true
                        self.homeTableView.reloadData()
                    }
                }
                if let block = self.block {
                    block(type, self.viewModel.arrDataForSeviceCenterProgress.count)
                }
            }
        }
    }
    
    func setupUI() {
        gk_navBarAlpha = 0
        gk_navigationBar.isHidden = true
        homeTableView = {
            let tableView = UITableView(frame: .zero, style: .grouped)
            tableView.backgroundColor = .clear
            tableView.separatorStyle = .none
            tableView.showsHorizontalScrollIndicator = false
            tableView.showsVerticalScrollIndicator = false
            tableView.rowHeight = UITableView.automaticDimension
            tableView.estimatedRowHeight = 81.0
            tableView.dataSource = self
            tableView.delegate = self
            tableView.register(cellWithClass: YHServiceOrderProgressTableViewCell.self)
            return tableView
        }()
        view.addSubview(homeTableView)
        homeTableView.snp.makeConstraints { make in
            make.top.right.left.bottom.equalToSuperview()
        }
        
        view.addSubview(noDataView)
        noDataView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview()
            make.width.equalTo(KScreenWidth)
            make.height.equalTo(150)
        }
    }
}

extension YHServiceOrderListView : UITableViewDelegate,UITableViewDataSource {
    func numberOfSections(in tableView: UITableView) -> Int {
        return self.viewModel.arrDataForSeviceCenterProgress.count
    }

    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {

        return 1
    }

    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return kMargin
    }

    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: kMargin))
        return view
    }

    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0
    }

    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }


    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 128
    }

    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell0 = tableView.dequeueReusableCell(withClass: YHServiceOrderProgressTableViewCell.self)
        cell0.selectionStyle = .none

        if indexPath.section < self.viewModel.arrDataForSeviceCenterProgress.count {
            cell0.dataModel = self.viewModel.arrDataForSeviceCenterProgress[indexPath.section]
        }
        return cell0
    }

    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let model = self.viewModel.arrDataForSeviceCenterProgress[indexPath.section]
        if model.status == 1 {
            return
        } else {
            //1 证件 2 信息完善 3 我的评分 4 我的方案 5 我的签字 6我的文书
            if model.type == 1 {
                let vc = YHMineCertificateEntryViewController()
                vc.orderId = orderID
                navigationController?.pushViewController(vc)
            } else if model.type == 2 {
                let vc = YHInformationPerfectListVC()
                vc.orderId = orderID
                navigationController?.pushViewController(vc)
            } else if model.type == 3 {
                let vc = YHScoreDetailViewController()
                vc.orderId = orderID
//                vc.model = serviceCenterMainReqVM.allInfoScoreModel
                navigationController?.pushViewController(vc)
            } else if model.type == 4 {
                let vc = YHMineSchemeViewController()
                navigationController?.pushViewController(vc)
            } else if model.type == 5 {
                let vc = YHMySignatureListViewController()
                vc.orderId = orderID
                navigationController?.pushViewController(vc)
            } else if model.type == 6 {
                let vc = YHMyDocumentsListViewController()
                vc.orderId = orderID
                vc.mobile = mobile
                navigationController?.pushViewController(vc)
            }
        }
    }
}


extension YHServiceOrderListView: JXSegmentedListContainerViewListDelegate {
    func listView() -> UIView {
        return view
    }
}
