//
//  YHFileListViewController.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/17.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import Photos
/*
 文件清单
 */

class YHFileListViewController: YHBaseViewController {
    
    var orderId : Int?
    private let certificateReqVM : YHCertificateViewModel = YHCertificateViewModel()
    
    
    
    private lazy var headView : YHFileListHeaerView = {
        let view = YHFileListHeaerView()
        view.backgroundColor = .clear
        return view
    }()
    
    private lazy var myScrollView : UIScrollView = {
        let view = UIScrollView()
        view.backgroundColor = .white
        return view
    }()
    
    
    private lazy var myContentView : YHFileListContentView = {
        let view = YHFileListContentView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius12
        view.clipsToBounds = true
        return view
    }()
    
    
    private lazy var bottomView : YHFileListBottomView = {
        var bottomView : YHFileListBottomView = YHFileListBottomView()
        bottomView.nextButton.isEnabled = false
        bottomView.layer.opacity = 0.8
        return bottomView
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        loadData()
        loadData2()
    }
    
    
    private lazy var footLable : UILabel = {
        
        let footLable = UILabel()
        footLable.text = "*感谢您对银河移民的信赖，以上信息均用于香港优才签证申请，银河移民承诺对您所提供的信息将绝对保密"
        footLable.textColor = .white
        footLable.textAlignment = .center
        footLable.font = UIFont.PFSC_R(ofSize: 12)
        footLable.numberOfLines = 0
        footLable.lineBreakMode = .byWordWrapping
        
        return footLable
    }()
}

extension YHFileListViewController {
    func loadData() {
        if let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") {
            let param = ["order_id":orderID,"node":"1","state":"1"]
            //            let param = ["order_id":"11758","node":"1","state":"1"] //for test hjl
            certificateReqVM.getCertificateFileListData(params: param) { success, error in
                if success == true {
                    self.myContentView.dataModel = self.certificateReqVM.arrFileListData
                    
                    self.myContentView.layoutIfNeeded()
                    
                    let r = self.myContentView.bounds
                    self.myContentView.frame = CGRect(x: kMargin, y: 217, width: KScreenWidth - 2*kMargin, height: r.height)
                    
                    self.footLable.frame = CGRect(x: 28, y: 217 + r.height + 29, width: KScreenWidth - 2*28, height: 36)
                    
                    self.myScrollView.contentSize =  CGSize(width: KScreenWidth, height: r.height + 217 + 29 + 36 + 41)
                    
                    
                    self.bottomView.nextButton.isEnabled = true
                    self.bottomView.layer.opacity = 1.0
                } else {
                    YHHUD.flash(message: error?.errorMsg ?? "请求出错")
                }
            }
        } else {
            printLog("error : orderID 为空")
        }
    }
    
    func loadData2() {
        if let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") {
            let param = ["order_id":orderID,"node":"1","state":"1"]
            certificateReqVM.getCertificateStatisticData(params: param) { success, error in
                if success == true {
                    self.headView.dataModel = self.certificateReqVM.certificateEntryModel
                } else {
                    YHHUD.flash(message: error?.errorMsg ?? "请求出错")
                }
            }
        } else {
            printLog("error : orderID 为空")
        }
    }
    
    
    func setupUI() {
        gk_navTitle = "文件清单"
        gk_navBarAlpha = 1.0
        gk_navBackgroundColor = .white
        
        view.backgroundColor = UIColor(hex:0x0D37C7, alpha: 1.0)
        
        view.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(YHFileListBottomView.viewH)
        }
        
        bottomView.block = { [self] flag in
            if flag == 1 {
                YHHUD.show(.progress(message: "正在生成图片"))
                if let image = self.captureScrollView(scrollView: self.myScrollView) {
                    YHHUD.hide()
                    saveImageToPhotosAlbum(image: image)
                } else {
                    YHHUD.hide()
                    YHHUD.flash(message: "生成图片失败")
                }
            }
        }
        
        myScrollView.backgroundColor = UIColor(hex:0x0D37C7, alpha: 1.0)
        
        view.addSubview(myScrollView)
        myScrollView.frame = CGRect(x: 0, y: k_Height_NavigationtBarAndStatuBar, width: KScreenWidth, height: KScreenHeight - k_Height_NavigationtBarAndStatuBar - YHFileListBottomView.viewH)
        
        
        myScrollView.contentSize = CGSize(width: KScreenWidth, height: 2000)
        
        myScrollView.addSubview(headView)
        headView.frame = CGRect(x: 0, y: 0, width: KScreenWidth, height: YHFileListHeaerView.viewH)
        
        myScrollView.addSubview(myContentView)
        myContentView.snp.makeConstraints { make in
            make.top.equalTo(217)
            make.left.equalTo(kMargin)
            make.width.equalTo(KScreenWidth - 2*kMargin)
        }
        
        myScrollView.addSubview(footLable)
    }
    
    func captureScrollView(scrollView : UIScrollView) -> UIImage? {
        
        scrollView.showsVerticalScrollIndicator = false
        UIGraphicsBeginImageContextWithOptions(scrollView.contentSize, false, UIScreen.main.scale)
        let savedContentOffset = scrollView.contentOffset
        let savedFrame = scrollView.frame
        
        scrollView.contentOffset = CGPoint.zero
        scrollView.frame = CGRect(x: 0, y: 0, width: scrollView.contentSize.width, height: scrollView.contentSize.height)
        
        scrollView.layer.render(in: UIGraphicsGetCurrentContext()!)
        let image = UIGraphicsGetImageFromCurrentImageContext()
        scrollView.contentOffset = savedContentOffset
        scrollView.frame = savedFrame
        UIGraphicsEndImageContext()
        
        scrollView.showsVerticalScrollIndicator = true
        return image
    }
    
    
    func saveImageToPhotosAlbum(image: UIImage) {
        // 确保应用有权访问相册
        PHPhotoLibrary.requestAuthorization { status in
            if status == .authorized {
                // 保存图片到相册
                DispatchQueue.main.sync {
                    UIImageWriteToSavedPhotosAlbum(image, self, #selector(self.image(image:didFinishSavingWithError:contextInfo:)), nil)
                }
            } else {
                YHHUD.flash(message: "没有访问图库权限")
            }
        }
    }
    
    
    @objc func image(image: UIImage,didFinishSavingWithError: NSError?,contextInfo: AnyObject) {
        if didFinishSavingWithError != nil {
            YHHUD.flash(message: "保存失败")
            return
        }
        YHHUD.flash(message: "保存成功")
    }
}
