//
//  YHFileListItemView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFileListItemView: UIView {
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    //index
    private lazy var indexLable : UILabel = {
        let lable0 = UILabel(text: "index")
        lable0.textColor = UIColor.mainTextColor
        lable0.font = UIFont.PFSC_B(ofSize: 19)
        lable0.textAlignment = .center
        return lable0
    }()
    
    //title
    private lazy var titleLable : UILabel = {
        let lable0 = UILabel(text: "title")
        lable0.textColor = UIColor.mainTextColor
        lable0.font = UIFont.PFSC_R(ofSize: 15)
        lable0.numberOfLines = 0
        lable0.lineBreakMode = .byWordWrapping
        return lable0
    }()
    
    //subtitle
    private lazy var subtitleLable : UILabel = {
        let lable0 = UILabel(text: "subtitle")
        lable0.textColor = UIColor.labelTextColor2
        lable0.font = UIFont.PFSC_R(ofSize: 12)
        lable0.numberOfLines = 0
        lable0.lineBreakMode = .byWordWrapping
        return lable0
    }()
    
    //status
    private lazy var statusLable : UILabel = {
        let lable0 = UILabel(text: "状态")
        lable0.textColor = UIColor.brandMainColor
        lable0.font = UIFont.PFSC_R(ofSize: 12)
        lable0.numberOfLines = 0
        lable0.lineBreakMode = .byWordWrapping
        lable0.textAlignment = .right
        return lable0
    }()
    
    //line
    private lazy var line : UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    
    
    var dataModel : YHFileListSubModel? {
        didSet {
            updateUI()
        }
    }
    
    var myIndex : Int  = -1 {
        didSet {
            updateIndex()
        }
    }
}

private extension YHFileListItemView {
    func initView() {
        addSubview(indexLable)
        indexLable.snp.makeConstraints { make in
            make.left.equalTo(8)
            make.width.equalTo(26)
            make.height.equalTo(20)
            make.centerY.equalToSuperview()
        }
        
        addSubview(statusLable)
        statusLable.snp.makeConstraints { make in
            make.right.equalTo(-26)
            make.centerY.equalToSuperview()
            make.height.equalTo(20)
            make.width.equalTo(60)
        }
        
        
        addSubview(titleLable)
        titleLable.snp.makeConstraints { make in
            make.top.equalTo(kMargin)
            make.left.equalTo(40)
            make.right.equalTo(statusLable.snp.left).offset(-12)
        }
        
        
        addSubview(subtitleLable)
        subtitleLable.snp.makeConstraints { make in
            make.top.equalTo(titleLable.snp.bottom).offset(2)
            make.left.equalTo(titleLable.snp.left)
            make.right.equalTo(titleLable.snp.right)
        }
        
        addSubview(line)
        line.snp.makeConstraints { make in
            make.top.equalTo(subtitleLable.snp.bottom).offset(kMargin)
            make.left.right.equalToSuperview()
            make.height.equalTo(0.5)
            make.bottom.equalToSuperview()
        }
    }
}

extension YHFileListItemView {
    func updateUI() {
        guard let dataModel = dataModel else { return }
        titleLable.text = dataModel.name
        subtitleLable.text = dataModel.type_name
        
        var text : String = "--"
        var color : UIColor = .failColor
        
        
        if dataModel.check_status == 2 {
            text = "需重传"
            color = .failColor
        } else if  dataModel.check_status == 3 {
            text = "待提交"
            color = .brandMainColor
        } else {
            text = "需过滤" + String(dataModel.check_status)
            color = UIColor.purple
        }
        
        statusLable.text = text
        statusLable.textColor = color
        
        
    }
    
    
    func updateIndex() {
        let index = String(myIndex + 1)
        indexLable.text = index.defaultStringIfEmpty(detaultValue: "-")
    }
}
