//
//  YHCertificateModel.swift
//  galaxy
//
//  Created by edy on 2024/3/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHUploadCertificateInfo: SmartCodable {
    var categoryData: YHCategoryData = YHCategoryData()
    var supplementList: [YHSupplementInfo] = []

    enum CodingKeys: String, CodingKey {
        case categoryData = "category_data"
        case supplementList = "supplement_list"
    }
    
    required init() {
        
    }

    init(categoryData: YHCategoryData, supplementList: [YHSupplementInfo]) {
        self.categoryData = categoryData
        self.supplementList = supplementList
    }
}

// MARK: - YHCategoryData
class YHCategoryData: SmartCodable {
    var applicantName: String = ""
    var categoryId: Int = 0
    var checkStatus: Int = 0
    
    var sex: String = ""
    var userName: String = ""
    
    enum CodingKeys: String, CodingKey {
        case applicantName = "applicant_name"
        case categoryId = "category_id"
        case checkStatus = "check_status"
        case sex = "sex"
        case userName = "user_name"
    }
    
    required init() {
        
    }

    init(applicantName: String = "", categoryId: Int = 0, checkStatus: Int = 0) {
        self.applicantName = applicantName
        self.categoryId = categoryId
        self.checkStatus = checkStatus
    }
}

// MARK: - YHSupplementList
class YHSupplementInfo: SmartCodable {
    var id: Int = 0
    var name: String = ""
    var typeName: String = ""
    var checkStatus: Int = 0
    var templateCateName: String = ""
    var templateCateShortName: String = ""
    var templateCateShortColor: String = ""
    var applicantName: String = ""
    var nameExtra: YHNameExtra = YHNameExtra()
    var templateInfo: YHTemplateInfo = YHTemplateInfo()
    var auditContent: String = ""
    var uploadRequirement: Int = 0
    var contentUrl: [YHContentUrl] = []
    
    func getStatusName() -> String {
        if checkStatus == YHCertificateUploadStatus.review.rawValue {
            return "审核中".local
        } else if checkStatus == YHCertificateUploadStatus.preUpload.rawValue {
            return "待上传".local
        } else if checkStatus == YHCertificateUploadStatus.finish.rawValue {
            return "已完成".local
        } else if checkStatus == YHCertificateUploadStatus.rejected.rawValue {
            return "已驳回".local
        }
        return ""
    }
    
    func isNeedSupplemnt()->Bool {
        // 0:必须提供, 1:如无可不提供
        return uploadRequirement == 0
    }

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case name = "name"
        case typeName = "type_name"
        case checkStatus = "check_status"
        case templateCateName = "template_cate_name"
        case templateCateShortName = "template_cate_short_name"
        case templateCateShortColor = "template_cate_short_color"
        case applicantName = "applicant_name"
        case nameExtra = "name_extra"
        case templateInfo = "template_info"
        case auditContent = "audit_content"
        case uploadRequirement = "upload_requirement"
        case contentUrl = "content_url"
    }
    
    required init() {
        
    }

    init(id: Int = 0, name: String = "", typeName: String = "", checkStatus: Int = 0, templateCateName: String = "", templateCateShortName: String = "", templateCateShortColor: String = "", applicantName: String = "", nameExtra: YHNameExtra = YHNameExtra(), templateInfo: YHTemplateInfo = YHTemplateInfo(), contentUrl: [YHContentUrl] = []) {
        self.id = id
        self.name = name
        self.typeName = typeName
        self.checkStatus = checkStatus
        self.templateCateName = templateCateName
        self.templateCateShortName = templateCateShortName
        self.templateCateShortColor = templateCateShortColor
        self.applicantName = applicantName
        self.nameExtra = nameExtra
        self.templateInfo = templateInfo
        self.contentUrl = contentUrl
    }
}

// MARK: - YHContentUrl
class YHContentUrl: SmartCodable {
    var url: String = ""
    var name: String = ""
    var type: Int = 0
    var recognitionType: Int = 0
    var suffix: String = ""
    var updatedAt: String = ""

    enum CodingKeys: String, CodingKey {
        case url = "url"
        case name = "name"
        case type = "type"
        case recognitionType = "recognition_type"
        case suffix = "suffix"
        case updatedAt = "updated_at"
    }
    
    // 获取文件后缀名 eg:123.pdf -> pdf
    func getFileSuffixName()->String {
        let res1 = url.pathExtension.lowercased()
        if !res1.isEmpty {
            return res1
        }
        let res2 = name.pathExtension.lowercased()
        if !res2.isEmpty {
            return res2
        }
        if !suffix.isEmpty {
            return suffix
        }
        return ""
    }
    
    // 获取文件名(不包含后缀) eg:123.pdf -> 123
    func getFileNameWithoutSuffix()->String {
        if name.isEmpty {
            return name
        }
        if !name.contains(".") {
            return name
        }
        if !name.pathExtension.isEmpty {
          let fileName = (name as NSString).deletingPathExtension
          return fileName
        }
        return ""
    }
    
    required init() {
        
    }

    init(url: String = "", name: String = "", type: Int = 0, recognitionType: Int = 0, suffix: String = "", updatedAt: String = "") {
        self.url = url
        self.name = name
        self.type = type
        self.recognitionType = recognitionType
        self.suffix = suffix
        self.updatedAt = updatedAt
    }
}

// MARK: - YHNameExtra
class YHNameExtra: SmartCodable {
    var applicant: String = ""
    var userName: String = ""
    var organization: String = ""

    enum CodingKeys: String, CodingKey {
        case applicant = "applicant"
        case userName = "user_name"
        case organization = "organization"
    }
    
    required init() {
        
    }

    init(applicant: String = "", userName: String = "", organization: String = "") {
        self.applicant = applicant
        self.userName = userName
        self.organization = organization
    }
}

// MARK: - YHTemplateInfo
class YHTemplateInfo: SmartCodable {
    var id: Int = 0
    var name: String = ""
    var description: String = ""
    var materialPath: [YHMaterialPath] = []
    var guideFilePath: [YHMaterialPath] = []
    
    func isNeedShowTemplate() -> Bool {
        if self.description.isEmpty && self.materialPath.isEmpty && self.guideFilePath.isEmpty {
            return false
        }
        return true
    }
    
    required init() {
        
    }

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case name = "name"
        case description = "description"
        case materialPath = "material_path"
        case guideFilePath = "guide_file_path"
    }

    init(id: Int = 0, name: String = "", description: String = "", materialPath: [YHMaterialPath] = [], guideFilePath: [YHMaterialPath] = []) {
        self.id = id
        self.name = name
        self.description = description
        self.materialPath = materialPath
    }
}

// MARK: - YHMaterialPath
class YHMaterialPath: SmartCodable {
    var name: String = ""
    var url: String = ""
    // 自定义类型 0：模版 1：指引
    var type: Int = 0

    enum CodingKeys: String, CodingKey {
        case name = "name"
        case url = "url"
    }
    
    required init() {
        
    }

    init(type:Int,  name: String = "", url: String = "") {
        self.type = type
        self.name = name
        self.url = url
    }
}
