
//
//  YHCertificateViewModel.swift
//  galaxy
//
//  Created by edy on 2024/3/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

enum YHCertificateCategoryId: Int {
    // 子女
    case child = 18
    // 配偶
    case spouse = 19
    // 主申请人
    case mainApplicant = 20
}

enum YHCertificateUploadStatus : Int {
    // 全部
    case all = -1
    // 审核中
    case review = 0
    // 已完成
    case finish = 1
    // 审核中
    case rejected = 2
    // 待上传
    case preUpload = 3
}


class YHCertificateViewModel: YHBaseViewModel {
    var certificateEntryModel : YHCertificateEntryModel?
    var arrQuestionAndAnswer : [YHQuestionAndAnswerModel?] = []
    
    var arrFileListData : [YHFileListModel?] = []
    
    
    
    //我的证件  清单列表数据
    func getCertificateFileListData( params:[String : Any],callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Certificate.documentListApi
        
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                let dic = json.data
                guard let resultModel = [YHFileListModel].deserialize(array: dic as? [Any]) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    
                    callBackBlock(false,err)
                    return
                }
                
                
                for (_,item) in resultModel.enumerated() {
                    let arr = item?.supplement_list.filter { (item) -> Bool in
                        return item.check_status == 2 || item.check_status == 3
                     }
                    item?.supplement_list = arr ?? []
                }
                
//                var arr = resultModel.filter { (item) -> Bool in
//                    if let ttt = item,ttt.supplement_list.count > 0 {
//                        return true
//                    }
//                    return false
//                 }
                
                var arr = resultModel
                
                //添加 写死的数据类型
                let tmpModel = YHFileListModel()
                tmpModel.ApplicantName = "温馨提示"
                tmpModel.type = 1
                tmpModel.arrTxt = ["1.以上资料请提供清晰完整的彩色扫描件。","2.照片最好同时提供电子档及时通知我们以避免对申请结果产生影响。","3.申请递交之后，如目前所报备的情况有任何变化（包含婚姻状况、新生子女、工作情况、亲属关系变化），请及时通知我们以避免对申请结果产生影响。"]
                arr.append(tmpModel)
                self.arrFileListData = arr
                
                
                callBackBlock(true,nil)
            } else {
                
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false,err)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    //获取问答列表
    func getQuestionAndAnserList( params:[String : Any],callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Certificate.questionAndAnswerApi
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                let dic = json.data
                
                guard let resultModel = [YHQuestionAndAnswerModel].deserialize(array: dic as? [Any]) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    
                    callBackBlock(false,err)
                    return
                }
                self.arrQuestionAndAnswer = resultModel
                
                callBackBlock(true,nil)
            } else {
                
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false,err)
                
            }
            
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    
    //我的证件  状态数据统计
    func getCertificateStatisticData( params:[String : Any],callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Certificate.statisticApi
        
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                let dic = json.data
                guard let resultModel = YHCertificateEntryModel.deserialize(dict: dic as? [AnyHashable : Any]) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    
                    callBackBlock(false,err)
                    return
                }
                self.certificateEntryModel = resultModel
                callBackBlock(true,nil)
            } else {
                
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false,err)
                
            }
            
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    func getCertificateList(params:[String: Any], callBack:@escaping (_ listInfo: YHUploadCertificateInfo?, _ error:YHErrorModel?)->()) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Certificate.certificateListApi
        let _ = YHNetRequest.getRequest(url: strUrl, params:params) { json, code in
            
            printLog("model 是 ==> \(json)")
            let dic = json.data
            
            if json.code == 200 {
                guard let result = YHUploadCertificateInfo.deserialize(dict: dic as? Dictionary ) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    
                    callBack(nil, err)
                    return
                }
                callBack(result, nil)
                
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBack(nil, error)
            }
            
        } failBlock: { err in
            callBack(nil, err)
        }
    }
    
    // 上传/重命名/删除 证件
    func updateCertificates(params:[String : Any], callBack:@escaping ((Bool, YHErrorModel?)->())) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Certificate.certificateUploadApi
        
         
        let _ = YHNetRequest.postRequest(url: strUrl, params:params) { json, code in
            
            if json.code == 200 {
                callBack(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBack(false, error)
            }
            
        } failBlock: { err in
            callBack(false, err)
        }
    }
    
    // 更改证件
    // operation参数必填，必须是：add(上传)、del（删除）、rename（重命名）
    func updateCertificateItem(supplementsId:Int, urlModel: YHContentUrl, operation:String, rename:String, callBack:((Bool, YHErrorModel?)->())?) {
        
        var name = urlModel.name
        if operation == "rename" {
            name = rename
        }
        let dic:[String : Any] = [
                "id" : supplementsId,
                "content_url": [
                    "name": name,
                    "url": urlModel.url,
                    "suffix": urlModel.suffix]]
        let params: [String: Any] = [
            "file_info" : [dic],
            "operation" : operation,
        ]
    
        self.updateCertificates(params: params) {
            [weak self] success, error in
            guard self != nil else { return }
            callBack?(success, error)
        }
    }
}
