//
//  YHHKPlanItemView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/1.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKPlanItemView: UIView {
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    private lazy var line : UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    
    private lazy var numberLabel : UILabel = {
        let view = UILabel()
        view.text = "--/100"
        view.font = UIFont.PFSC_R(ofSize: 12)
        view.textColor = UIColor.placeHolderColor
        view.textAlignment = .right
        return view
    }()
    
    
    private lazy var myTextView : UITextView = {
        let view = UITextView()
        view.textColor = UIColor.mainTextColor
        view.font = UIFont.PFSC_R(ofSize: 14)
        view.backgroundColor = .clear
        return view
    }()
    
    
    
    private lazy var nameLable : UILabel = {
        let lable0 = UILabel(text: "1、主要事业成就")
        lable0.textColor = UIColor.mainTextColor
        lable0.font = UIFont.PFSC_M(ofSize: 17)
        return lable0
    }()
    
    
    private lazy var iconImageV : UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "other_info_warning")
        view.contentMode = .scaleAspectFill
        return view
    }()
    
    
    var dataMode : YHHKPlanDocModel? {
        didSet {
            updateUI()
        }
    }
    let holdView : UIView = UIView()
}

private extension YHHKPlanItemView {
    func initView() {
        backgroundColor = .clear
        
        //应香港入境处最新要求，
        //赴港计划书格式、内容作出调整，共分为六部分，每部分不得超过100字(不含标点)
        //。其中“赴港具体计划”仅代表个人预期规划，无须严格执行。
        
        addSubview(line)
        line.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.height.equalTo(1)
            make.bottom.equalToSuperview()
        }
        
        holdView.backgroundColor = UIColor.white
        addSubview(holdView)
        
        holdView.snp.makeConstraints { make in
            make.top.equalTo(0)
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.bottom.equalTo(line.snp.top)
        }
        
        holdView.addSubview(nameLable)
        nameLable.snp.makeConstraints { make in
            make.top.equalTo(18)
            make.left.equalTo(0)
            make.height.equalTo(20)
        }
        
        
        holdView.addSubview(iconImageV)
        iconImageV.snp.makeConstraints { make in
            make.left.equalTo(nameLable.snp.right).offset(4)
            make.centerY.equalTo(nameLable)
            make.height.width.equalTo(16)
        }
        
        
        let tap : UITapGestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(tapButton(gestureRecognizer:)))
        iconImageV.isUserInteractionEnabled = true
        iconImageV.addGestureRecognizer(tap)
        
        
        let subHoldView : UIView = UIView()
        subHoldView.backgroundColor = UIColor.contentBkgColor
        subHoldView.layer.cornerRadius = kCornerRadius6
        subHoldView.clipsToBounds = true
        holdView.addSubview(subHoldView)
        subHoldView.snp.makeConstraints { make in
            make.top.equalTo(nameLable.snp.bottom).offset(12)
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.bottom.equalTo(line.snp.top).offset(-18)
        }
        
        subHoldView.addSubview(numberLabel)
        numberLabel.snp.makeConstraints { make in
            make.right.equalTo(-12)
            make.height.equalTo(18)
            make.bottom.equalToSuperview().offset(-8)
        }
        
        subHoldView.addSubview(myTextView)
        myTextView.snp.makeConstraints { make in
            make.top.left.equalToSuperview().offset(12)
            make.right.equalTo(-12)
            make.height.greaterThanOrEqualTo(80)
            make.bottom.equalTo(numberLabel.snp.top).offset(-2)
        }
        myTextView.delegate = self
//        myTextView.wrapToContent()
    }
    
    @objc func tapButton(gestureRecognizer:UITapGestureRecognizer) {
        guard let model = dataMode else { return }
        switch model.type  {
        case .planDocQuestion1:
            YHWholeScreenTipsView.show(type: .hkPlanQ1, targetView: iconImageV)
        case .planDocQuestion2:
            YHWholeScreenTipsView.show(type: .hkPlanQ2, targetView: iconImageV)
        case .planDocQuestion3:
            YHWholeScreenTipsView.show(type: .hkPlanQ3, targetView: iconImageV)
        case .planDocQuestion4:
            YHWholeScreenTipsView.show(type: .hkPlanQ4, targetView: iconImageV)
        case .planDocQuestion5:
            YHWholeScreenTipsView.show(type: .hkPlanQ5, targetView: iconImageV)
        case .planDocQuestion6:
            YHWholeScreenTipsView.show(type: .hkPlanQ6, targetView: iconImageV)
        case .unknow:
            printLog("")
        }
    }
    
    func updateUI() {
        guard let model = dataMode else { return }
        nameLable.text = model.title
        myTextView.text = model.content
        if model.canEditFlag {
            myTextView.isEditable = true
            myTextView.isSelectable = true
            myTextView.textColor = UIColor.mainTextColor
        } else {
            myTextView.isEditable = false
            myTextView.isSelectable = false
            myTextView.textColor = UIColor(hex: 0x222222, alpha: 0.5)
            
            myTextView.wrapToContent()
        }
        numberLabel.text = myTextView.text.count.string + "/100"
        if myTextView.text.count > 100 {
            numberLabel.textColor = .failColor
        } else {
            numberLabel.textColor = UIColor.placeHolderColor
        }
        
        if model.isLastData {
            line.isHidden = true
        } else {
            line.isHidden = false
        }
    }
}


extension YHHKPlanItemView : UITextViewDelegate {
    func textView(_ textView: UITextView, shouldChangeTextIn range: NSRange, replacementText text: String) -> Bool {
        if text.isEmpty {
            return true
        }
        let newLength = (textView.text as NSString).length + text.count - range.length
        return newLength <= 100
    }
    
    func textViewDidChange(_ textView: UITextView) {
        guard let model = dataMode else { return }
        guard let text = textView.text else { return }
        model.content = text
        numberLabel.text = myTextView.text.count.string + "/100"
        if myTextView.text.count > 100 {
            numberLabel.textColor = .failColor
        } else {
            numberLabel.textColor = UIColor.placeHolderColor
        }
    }
}
