//
//  YHHKPlanTipsCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/31.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHHKPlanTipsCell: UITableViewCell {

    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        initView()
        
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}


private extension YHHKPlanTipsCell {
    func initView() {
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        
        //应香港入境处最新要求，
        //赴港计划书格式、内容作出调整，共分为六部分，每部分不得超过100字(不含标点)
        //。其中“赴港具体计划”仅代表个人预期规划，无须严格执行。
        
        let holdView : UIView = UIView()
        holdView.backgroundColor = .white
        holdView.clipsToBounds = true
        holdView.layer.cornerRadius = kCornerRadius6
        contentView.addSubview(holdView)
        
        holdView.snp.makeConstraints { make in
            make.top.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
            make.bottom.equalTo(0)
        }
        
        
        
        let iconImagV = UIImageView(image: UIImage(named: "tips_icon"))
        iconImagV.contentMode = .scaleAspectFill
        holdView.addSubview(iconImagV)
        iconImagV.snp.makeConstraints { make in
            make.height.width.equalTo(14)
            make.left.equalTo(kMargin)
            make.top.equalTo(kMargin)
        }
        let tipsLabel = UILabel()
        tipsLabel.text = "温馨提示："
        tipsLabel.textColor = UIColor.brandMainColor
        tipsLabel.font = UIFont.PFSC_M(ofSize: 12)
        
        holdView.addSubview(tipsLabel)
        tipsLabel.snp.makeConstraints { make in
            make.height.width.equalTo(18)
            make.left.equalTo(iconImagV.snp.right).offset(8)
            make.right.equalTo(-kMargin)
            make.centerY.equalTo(iconImagV.snp.centerY)
        }
        
        
        
        
        let a: ASAttributedString = .init("应香港入境处最新要求，", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.labelTextColor2))
        
        let b: ASAttributedString = .init("赴港计划书格式、内容作出调整，共分为六部分，每部分不得超过100字", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.brandMainColor))
        
        let c: ASAttributedString = .init("。其中“赴港具体计划”仅代表个人预期规划，无须严格执行。", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.labelTextColor2))
        
        
        
        let contentLable = UILabel()
        contentLable.numberOfLines = 0
        contentLable.lineBreakMode = .byWordWrapping
        contentLable.attributed.text = a + b + c
        holdView.addSubview(contentLable)
        contentLable.snp.makeConstraints { make in
            make.top.equalTo(tipsLabel.snp.bottom).offset(6)
            make.right.equalTo(-kMargin)
            make.left.equalTo(kMargin)
            make.bottom.equalToSuperview().offset(-kMargin)
        }
        holdView.layoutIfNeeded()
        
        
        let imageV44 = UIImageView()
        imageV44.frame = holdView.bounds
        imageV44.image = UIImage(named: "tips_cell_bkg")
        imageV44.contentMode = .scaleAspectFill
        imageV44.layer.zPosition = -1
        holdView.addSubview(imageV44)
    }
}
