//
//  YHMineSchemeVC.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/17.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

/*
 我的方案
 */

class YHMineSchemeViewController: YHBaseViewController {
    
    var tableView: UITableView!
    var dataSource: [YHScemeItemModel]? = []
    
    lazy var reqSchemeVM : YHMySchemeViewModel = {
        let vm = YHMySchemeViewModel()
        return vm
    }()
    
    lazy var headView : YHSchemeTableHeadView = {
        let headView = YHSchemeTableHeadView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 566))
        return headView
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        gk_navTitle = "我的方案"
        gk_navTitleColor = .white
        gk_navBarAlpha = 1
        gk_navBackgroundImage = UIImage(named: "my_scheme_nav")
        gk_backImage = UIImage(named: "nav_icon_back_white")
        setView()
        loadData()
    }
}

extension YHMineSchemeViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return dataSource?.count ?? 0
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHSchemeTableViewCell.self)
        cell.dataSource = dataSource?[indexPath.row]
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        if indexPath.row == 0 {
            return 199
        } else if indexPath.row == 1 {
            return 251
        } else if indexPath.row == 2 {
            return 190
        }
        return 0
    }
}


extension YHMineSchemeViewController {
    func getData() {
        let model1 = YHScemeItemModel(title: "行业定位", mainMessage: "根据您目前给来的材料，初步建议您申请的行业：--", lightMessage: "--", subMessage: "后续会根据您文书准备的补充情况来最终确定，如有修改会再告知您。")
        let model2 = YHScemeItemModel(title: "资料清单", buttonTitle: "资料清单", mainMessage: "这是您的资料清单，请您前往查看。请您在1-2周内上传基础类证件哦，需要重新办理的可以晚些提供。需要注意的点如下：", lightMessage: "1-2周内", subMessage: "(1)港澳通如未办理，请尽快办理好反馈过来；\n(2)如为国内学校，需要尽快办理学位认证报告；\n(3)如为海外学校，需提供成绩单副本")
        let model3 = YHScemeItemModel(title: "文书清单", buttonTitle: "文书写作", mainMessage: "这是您的文书清单，包括推荐信、赴港计划书，我写好后会发在微信里，与您一起沟通进行哈。3周-4周左右完成，需要咱们共同配合完成的噢", lightMessage: "3周-4周")
        dataSource = [model1, model2, model3]
        tableView.reloadData()
    }
    
    func updateDataSource() {
        
    }
    
    func setView() {
        view.backgroundColor = .contentBkgColor
        tableView = {
            let tableView = UITableView(frame:.zero, style:.plain)
            if #available(iOS 11.0, *) {
                tableView.contentInsetAdjustmentBehavior = .never
            }
            tableView.backgroundColor = .clear
            tableView.separatorStyle = .none
            tableView.delegate = self
            tableView.dataSource = self
            tableView.tableFooterView = YHSchemeTableFooterView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 112))
            
            tableView.tableHeaderView = headView
            tableView.register(cellWithClass: YHSchemeTableViewCell.self)
            tableView.bounces = false
            return tableView
        }()
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.left.right.bottom.equalToSuperview()
        }
    }
    
    
    func loadData() {
        if let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") {
            let param = ["order_id":orderID]
            reqSchemeVM.getMySchemeData(params: param) { success, error in
                if success == true {
                    
                    guard let model = self.reqSchemeVM.schemeModel else { return }
                    
                    let industry = model.industry.defaultStringIfEmpty()
                    let model1 = YHScemeItemModel(title: "行业定位", mainMessage: "根据您目前给来的材料，初步建议您申请的行业：" + industry, lightMessage: industry, subMessage: "后续会根据您文书准备的补充情况来最终确定，如有修改会再告知您。")
                    let model2 = YHScemeItemModel(title: "资料清单", buttonTitle: "资料清单", mainMessage: "这是您的资料清单，请您前往查看。请您在1-2周内上传基础类证件哦，需要重新办理的可以晚些提供。需要注意的点如下：", lightMessage: "1-2周内", subMessage: "(1)港澳通如未办理，请尽快办理好反馈过来；\n(2)如为国内学校，需要尽快办理学位认证报告；\n(3)如为海外学校，需提供成绩单副本")
                    let model3 = YHScemeItemModel(title: "文书清单", buttonTitle: "文书写作", mainMessage: "这是您的文书清单，包括推荐信、赴港计划书，我写好后会发在微信里，与您一起沟通进行哈。3周-4周左右完成，需要咱们共同配合完成的噢", lightMessage: "3周-4周")
                    self.dataSource = [model1, model2, model3]
                    self.tableView.reloadData()
                    
                    
                    
                    let ageTxt = "年龄" +  model.age_score.string + "分"
                    let eduTxtA = "学历" +  model.education_score_a.string + "分，名校加分XX分"
                    let workExp = "工作经验加分" +  model.work_experience_score.string + "分"
                    
                    let famous_enterprise = "名企加分" +  model.famous_enterprise.string + "分"
                    let talent_list = "人才清单加分" +  model.talent_list.string + "分"
                    
                    
                    let language = "语言加分" +  model.language_score.string + "分"
                    let family = "家庭背景加分" +  model.background_score.string + "分"
                    
                    let arrText : [String] = [ageTxt,eduTxtA,workExp,famous_enterprise,talent_list,language,family]
                    let arrH : [String] = [model.age_score.string,model.education_score_a.string,model.work_experience_score.string,model.famous_enterprise.string,model.talent_list.string,model.language_score.string,model.background_score.string]
                    
                    self.headView.dataSource = YHScemeHeadModel(totalScore: model.sum_score.string, scoreArray: arrText, scoreLightArray: arrH, addScore: "", name: model.username.defaultStringIfEmpty(),addtionStr: model.education_score_b.string)
                } else {
                    YHHUD.flash(message: error?.errorMsg ?? "请求出错")
                }
            }
        } else {
            printLog("error : orderID 为空")
        }
    }
}
