//
//  YHScoreDetailViewController.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/27.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import GKNavigationBarSwift
/*
 我的评分 /  评分详情
 */

class YHScoreDetailViewController: YHBaseViewController {
    var orderId : Int?
    var model : YHContactInfoScoreModel? {
        didSet {
            
        }
    }
    private let serviceCenterMainReqVM : YHServiceCenterMainViewModel = YHServiceCenterMainViewModel()
    
    //头部背景图片
    lazy var headBkgImagV: UIImageView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "score_bkg")
        imagV.contentMode = .scaleAspectFill
        return imagV
    }()
    
    
    var homeTableView: YHGestureTableView = {
        let tableView = YHGestureTableView(frame: .zero, style:.grouped)
        tableView.backgroundColor = .clear
        tableView.separatorStyle = .none
        tableView.showsHorizontalScrollIndicator = false
        tableView.showsVerticalScrollIndicator = false
        tableView.rowHeight = UITableView.automaticDimension
        tableView.register(YHScorePersonInfoCell.self,forCellReuseIdentifier: YHScorePersonInfoCell.cellReuseIdentifier)
        tableView.register(YHScoreItemCell.self,forCellReuseIdentifier: YHScoreItemCell.cellReuseIdentifier)
        return tableView
    }()
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        //1.0
        initView()
        
        //2.0
        loadData()
    }
}

// MARK: - private methods
extension YHScoreDetailViewController {
    private func initView()->Void {
        gk_backStyle = .white
        gk_navTitle = "我的评分"
        gk_navTitleColor = .white
        
        
        
        view.addSubview(headBkgImagV)
        headBkgImagV.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(414)
        }
        
        
        homeTableView.delegate = self
        homeTableView.dataSource = self
        view.addSubview(homeTableView)
        homeTableView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.bottom.equalToSuperview()
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
        }
    }
    
    
    private func loadData() {
        if let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") {
            let param = ["order_id":orderID]
            serviceCenterMainReqVM.getMyScoreDetail(params: param) { success, error in
                if success == true {
                    
                } else {
                    YHHUD.flash(message: error?.errorMsg ?? "发生错误,请重试")
                }
                self.homeTableView.reloadData()
            }
        } else {
            YHHUD.flash(message: "订单号不存在")
        }
    }
    
}

// MARK: - delegates
// MARK: - UITableViewDelegate 和 UITableViewDataSource
extension YHScoreDetailViewController : UITableViewDelegate,UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 2
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if section == 0 {
            return 1
        }
        return 6
    }
    
    
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0
    }
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        if indexPath.section == 0 {
            let cell = tableView.dequeueReusableCell(withClass: YHScorePersonInfoCell.self)
            cell.selectionStyle = .none
            cell.dataModel = serviceCenterMainReqVM.myScoreResultData
            return cell
        }
        let cell = tableView.dequeueReusableCell(withClass: YHScoreItemCell.self)
        cell.selectionStyle = .none
        cell.optionData = self.serviceCenterMainReqVM.localScoreData?[indexPath.row + 1]
        return cell
    }
}
