//
//  YHChoiceButtonHoldView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
class YHChoiceButtonHoldView: UIView {
    typealias block = (_ index: String) -> ()
    var callBackBlock: block?
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .clear
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private var arrCheckBtns : [UIButton] = []
    var targetId : Int = -1
    var dataModel : [subsetModel] = [] {
        didSet {
            updateView()
        }
    }
    
    private func updateView() {
        var x : CGFloat = 0
        var y = 0
        
        arrCheckBtns.removeAll()
        
        for (index,item) in dataModel.enumerated() {
            
            let string = item.subset_name.isEmpty == false ? item.subset_name : "--"
            let font = UIFont.PFSC_M(ofSize: 14)// 设置字体样式及大小
            let maxWidth : CGFloat = KScreenWidth - 28 * 2 // label最大宽度限制
            let butGap : CGFloat = 25
            
            var boundingBox = CGRect()
            boundingBox = NSString(string: string).boundingRect(with: CGSize(width: KScreenWidth, height: .greatestFiniteMagnitude), options: [.usesLineFragmentOrigin], attributes: [.font : font], context: nil)
            let width = boundingBox.size.width
            
            if CGFloat(x) + width  + 18.0 + butGap  > maxWidth {
                x = 0
                y = y + 1
            }
            
            let btn = UIButton(type: .custom)
            btn.setTitle(string, for: .normal)
            btn.setTitle(string, for: .selected)
            btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
            btn.setTitleColor(UIColor.mainTextColor, for: .normal)
            btn.setTitleColor(UIColor.brandMainColor, for: .selected)
            btn.setImage(UIImage(named: "basic_info_radio_0"), for: .normal)
            btn.setImage(UIImage(named: "basic_info_radio_1"), for: .selected)
            btn.iconInLeft(spacing: 6)
            btn.tag = item.id
            btn.addTarget(self, action: #selector(clickCheckBtn(sender:)), for: .touchUpInside)
            addSubview(btn)
            
            
            let offy = y * 36
           
            
            if dataModel.count - 1 == index {
                //最后一个控件
                btn.snp.makeConstraints { make in
                    make.left.equalTo(x)
                    make.top.equalTo(offy)
                    make.height.equalTo(20)
                    make.width.equalTo(width + 18 + butGap)
                    make.bottom.equalToSuperview()
                }
            } else {
                btn.snp.makeConstraints { make in
                    make.left.equalTo(x)
                    make.top.equalTo(offy)
                    make.height.equalTo(20)
                    make.width.equalTo(width + 18 + butGap)
                }
            }
            
            if targetId == item.id {
                btn.isSelected = true
            } else {
                btn.isSelected = false
            }
            
            x = x + width + 18.0 + butGap
            arrCheckBtns.append(btn)
        }
    }
    
    
    @objc func clickCheckBtn(sender : UIButton) {
        //修改成单选逻辑
        if sender.isSelected != true {
            for item in arrCheckBtns {
                item.isSelected = false
            }
            sender.isSelected = true
//            model?.info = String(sender.tag)
//            block?(String(sender.tag))
            callBackBlock?(String(sender.tag))
        }
    }
}
