//
//  YHEducationDetailVC.swift
//  galaxy
//
//  Created by edy on 2024/2/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SwifterSwift
//import Toast_Swift

class YHEducationDetailVC: YHBaseViewController {
    
    //【WARNING!】新添加 传orderId 已有信息传detailId和orderId
    // 订单ID
    var orderId: Int = 0
    // 学历ID
    var detailId: Int = 0
    // 是否显示未填写错误提示
    var isNeedShowError = false
    let educationRequest:YHEducationRequestViewModel = YHEducationRequestViewModel()
    var detailInfo: YHEducationDetailInfo = YHEducationDetailInfo()
    var isChildsEditMode: YHFormTitleItemEditType = .none
    var isBrothersEditMode: YHFormTitleItemEditType = .none
    
    var items:[[YHFormItemProtocol]] = []
    
    lazy var tableView: UITableView = {
        
        let tableView = UITableView(frame:.zero, style:.grouped)
        
        if #available(iOS 11.0, *) {
            tableView.contentInsetAdjustmentBehavior = .never
        }
        tableView.estimatedSectionHeaderHeight = 14.0
        tableView.estimatedSectionFooterHeight = 1.0
        tableView.showsVerticalScrollIndicator = false
        tableView.backgroundColor = UIColor(hexString:"#F8F8F8")
        tableView.separatorStyle = .none
        tableView.delegate = self
        tableView.dataSource = self
        tableView.register(UITableViewCell.self, forCellReuseIdentifier: "UITableViewCell")
        tableView.register(YHFormItemTitleCell.self, forCellReuseIdentifier: YHFormItemTitleCell.cellReuseIdentifier)
        tableView.register(YHFormItemAddCell.self, forCellReuseIdentifier: YHFormItemAddCell.cellReuseIdentifier)
        tableView.register(YHFormItemInputTextCell.self, forCellReuseIdentifier: YHFormItemInputTextCell.cellReuseIdentifier)
        tableView.register(YHFormItemSelectSheetCell.self, forCellReuseIdentifier: YHFormItemSelectSheetCell.cellReuseIdentifier)
        return tableView
    }()
    
    var bottomView: YHSaveAndSubmitView = {
        let view = YHSaveAndSubmitView.createView()
        return view
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.gk_navTitle = "学历".local
        self.gk_navigationBar.backgroundColor = .white
        view.backgroundColor = UIColor(hexString:"#F8F8F8")
        createUI()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }
    
    func createUI() {
        
        view.addSubview(tableView);
        view.addSubview(bottomView)
        
        bottomView.saveBlock = {
            [weak self] in
            guard let self = self else { return }
            saveDetailInfo(isSubmit:false, isNeedPop: true, isShowToast: true)
        }
        
        bottomView.submitBlock = {
            [weak self] in
            guard let self = self else { return }
            submitInfo()
        }
        
        bottomView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalToSuperview()
            make.height.equalTo(YHSaveAndSubmitView.height)
        }
        
        tableView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(k_Height_NavigationtBarAndStatuBar)
            make.bottom.equalTo(bottomView.snp.top)
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
        }
        
        loadInfo()
        if self.detailId != 0 { // 有学历ID则该学历已存在
            getDetailInfo()
        }
    }
    
    func loadInfo() {
                
        items.removeAll()
        
        let title0 = YHFormTitleItem(type: .mainApplicantEducation)
        let item00 = YHFormDetailItem(type: .universityFullName)
        item00.tips = "请选择学校".local
        item00.value = detailInfo.college
        
        let item01 = YHFormDetailItem(type: .educationStyle)
        item01.tips = "请选择授课形式".local
        item01.value = detailInfo.teachingFormat
        
        let item02 = YHFormDetailItem(type: .educationTime)
        item02.tips = "请选择年月".local
        item02.value = detailInfo.admissionTime
        
        
        let item03 = YHFormDetailItem(type: .graduateTime)
        item03.tips = "请选择年月".local
        item03.value = detailInfo.graduateTime
        
        let item04 = YHFormDetailItem(type: .educationMajor)
        item04.tips = "请输入专业".local
        item04.value = detailInfo.major
        
        let item05 = YHFormDetailItem(type: .educationDegree)
        item05.tips = "请选择学位".local
        item05.value = detailInfo.degree
        
        let item06 = YHFormDetailItem(type: .degreeType)
        item06.tips = "请选择学位类型".local
        item06.value = detailInfo.degreeType

        let item07 = YHFormDetailItem(type: .educationCountry)
        item07.tips = "请输入国家及地区".local
        item07.value = detailInfo.schoolAddress.country
        
        let item08 = YHFormDetailItem(type: .educationCity)

        if detailInfo.isSchoolInAboard() {
            item08.value = detailInfo.schoolAddress.foreign
            item08.tips = "请输入城市".local

        } else {
            item08.value = detailInfo.schoolAddress.area.joined(separator: ",")
            item08.tips = "请选择城市".local
        }
        
        let arr0:[YHFormItemProtocol] = [title0, item00, item01, item02, item03, item04, item05, item06, item07, item08]
        items.append(arr0)
        self.tableView.reloadData()
    }
}

extension YHEducationDetailVC : UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return items.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if section >= items.count { return 0 }
        let arr = items[section]
        return arr.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        if indexPath.section >= items.count { return createDefaultCell(indexPath) }
        let arr:[YHFormItemProtocol] = items[indexPath.section]
        if indexPath.row >= arr.count {  return createDefaultCell(indexPath) }
        let item:YHFormItemProtocol = arr[indexPath.row]

        if item is YHFormTitleItem { // 是标题
            
            let formItem = item as! YHFormTitleItem
            let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemTitleCell.cellReuseIdentifier, for: indexPath) as! YHFormItemTitleCell
            cell.setTitleAndSubTitle(title:formItem.getTitle())
            return cell
        }
        
        if item is YHFormDetailItem {
            
            let detailItem = item as! YHFormDetailItem
            let cellType = getCellType(detailItem)
            if cellType == .inputText {
                let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemInputTextCell.cellReuseIdentifier, for: indexPath) as! YHFormItemInputTextCell
                var isValueValid = false
                if let value = detailItem.value, !value.isEmpty {
                    isValueValid = true
                }
                cell.setTips(detailItem.tips, isShow: (isNeedShowError && !isValueValid))
                cell.placeHolder = detailItem.placeHolder
                cell.isMust = detailItem.isNeed
                cell.title = detailItem.getTitle()
                cell.text = detailItem.value
                
                cell.textInputCondtion = {
                    textField in
                    
                    var max = -1
                    if detailItem.type == .educationMajor {
                        max = 50
                    } else if detailItem.type == .educationCity {
                        max = 100
                    }

                    if max > 0 {
                        if let textStr = textField.text {
                            textField.text = (textStr.count > max ? textStr[safe: ..<max] : textStr)
                        }
                    }
                    return true
                }
                
                cell.textChange = {
                    [weak self] (text, isEditEnd) in
                    guard let self = self else { return }
                    // 只有国外城市才需输入，国内城市使用的是选择器
                    if detailItem.type == .educationCity {
                        if let text = text, !text.isEmpty {
                            detailInfo.schoolAddress.foreign = text
                        } else {
                            detailInfo.schoolAddress.foreign = ""
                        }
                        
                    } else if detailItem.type == .educationMajor {
                        if let text = text, !text.isEmpty {
                            detailInfo.major = text
                        } else {
                            detailInfo.major = ""
                        }
                    }
                    if isEditEnd {
                        loadInfo()
                        saveInfoSilent()
                    }
                }
                return cell
                
            } else if cellType == .selectSheet {
                let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemSelectSheetCell.cellReuseIdentifier, for: indexPath) as! YHFormItemSelectSheetCell
                cell.isShowTipsButton = (detailItem.type == .degreeType)
                cell.tipsBtnClickBlock = {
                    YHWholeScreenTipsView.show(type: .degreeType, targetView: cell.tipsButton)
                }
                cell.placeHolder = detailItem.placeHolder
                cell.isMust = detailItem.isNeed
                cell.title = detailItem.getTitle()
                cell.detail = detailItem.value
                var isValueValid = false
                if let value = detailItem.value, !value.isEmpty {
                    isValueValid = true
                }
                cell.setTips(detailItem.tips, isShow: (isNeedShowError && !isValueValid))
                return cell
            }
        }
        
        let cell = tableView.dequeueReusableCell(withIdentifier: "UITableViewCell", for: indexPath)
        return cell
    }
    
    func tableView(_ tableView: UITableView, willDisplay cell: UITableViewCell, forRowAt indexPath: IndexPath) {
        
        if indexPath.section >= items.count { return  }
        let arr:[YHFormItemProtocol] = items[indexPath.section]
        if indexPath.row >= arr.count {  return }
        
        createCorner(cell: cell, arr: arr, indexPath: indexPath)
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        
        return UIView()
    }
    
    private func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> CGFloat {
        return 14.0
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
        let arr = items[indexPath.section]
        let item:YHFormItemProtocol = arr[indexPath.row]
        
        // 标题
        if item is YHFormTitleItem {
            return
        }
        if item is YHFormDetailItem {
            let detailItem = item as! YHFormDetailItem
            
            if detailItem.type == .universityFullName { // 选择大学名称
                
               let vc = YHCollegeSearchViewController()
               vc.orderId = self.orderId
               vc.searchCollegeName = detailInfo.college
               vc.selectBlock = {
                    [weak self] text in
                    guard let self = self else { return }
                    if let text = text, !text.isEmpty  {
                        detailInfo.college = text
                    } else {
                        detailInfo.college = ""
                    }
                    loadInfo()
                    saveInfoSilent()
                }
               self.navigationController?.pushViewController(vc)
                
            } else if detailItem.type == .educationStyle { // 授课形式
                
                YHSheetPickerView.show(type:.educationStyle, selectTitle:detailInfo.teachingFormat) {
                    [weak self]  item in
                    guard let self = self else { return }
                    detailInfo.teachingFormat = item.title
                    loadInfo()
                    saveInfoSilent()
                }
                
            } else if detailItem.type == .educationTime || detailItem.type == .graduateTime { // 入学及毕业年月
                
                var title = ""
                var dateStr = ""
                if detailItem.type == .educationTime {
                    title = "选择入学日期"
                    dateStr = detailInfo.admissionTime
                } else if detailItem.type == .graduateTime {
                    title = "选择毕业日期"
                    dateStr = detailInfo.graduateTime
                }
                YHDatePickView.show(type: .yyyymm, title: title, lastIsTaday: true, currentDay: dateStr) {
                    [weak self] dateStr in
                    guard let self = self else { return }
                    
                    let format = DateFormatter()
                    format.dateFormat = "yyyy-MM"
                    if let selectDate = format.date(from:dateStr) {
                        let selectTimeInterval = selectDate.timeIntervalSince1970
                        let currentTimeInterval = Date().timeIntervalSince1970
                        if detailItem.type == .educationTime { // 选择入学日期
                            // 入学日期须早于当前日期
                            if selectTimeInterval > currentTimeInterval {
                                YHHUD.flash(message: "入学日期须早于当前日期")
                                return
                            }
                            if !detailInfo.graduateTime.isEmpty, let endDate = format.date(from:detailInfo.graduateTime)  {
                                let endTimeInterval = endDate.timeIntervalSince1970
                                
                                if selectTimeInterval > endTimeInterval {
                                    YHHUD.flash(message: "入学日期须早于毕业日期")
                                    return
                                }
                            }
                            detailInfo.admissionTime = dateStr
                        }
                
                        
                        if detailItem.type == .graduateTime { // 选择毕业日期
        
                            if !detailInfo.admissionTime.isEmpty, let startDate = format.date(from:detailInfo.admissionTime)  {
                                let startTimeInterval = startDate.timeIntervalSince1970

                                if selectTimeInterval < startTimeInterval {
                                    YHHUD.flash(message: "毕业日期须晚于入学日期")
                                    return
                                }
                            }
                            detailInfo.graduateTime = dateStr
                        }
                    }
    
                    loadInfo()
                    saveInfoSilent()
                }
                
            } else if detailItem.type == .educationDegree { // 学位
                
                YHSheetPickerView.show(type:.educationDegree, selectTitle:detailInfo.degree) {
                    [weak self]  item in
                    guard let self = self else { return }
                    detailInfo.degree = item.title
                    loadInfo()
                    saveInfoSilent()
                }
                
            } else if detailItem.type == .degreeType { // 学位类型
                
                YHSheetPickerView.show(type: .degreeCategory, selectTitle:"工程学") {
                   [weak self]  selectItem in
                    guard let self = self else { return }
                    detailInfo.degreeType = selectItem.title
                    loadInfo()
                    saveInfoSilent()
                }
                
            } else if detailItem.type == .educationCountry { // 上课国家/地区
                
                let vc = YHSelectCountryViewController()
                vc.backLocationStringController = {
                    [weak self] country in
                    guard let self = self else { return }
                    detailInfo.schoolAddress.country = country
                    detailInfo.isAboardSchool = detailInfo.isSchoolInAboard()
                    loadInfo()
                    saveInfoSilent()
                }
                 self.navigationController?.pushViewController(vc)
                
            } else if detailItem.type == .educationCity { // 上课城市
                
                if detailInfo.isSchoolInAboard() { return }
                
                let vc = YHAddressViewController()
                vc.backLocationStringController = {
                     [weak self] (string1, string2, string3, string4) in
                     guard let self = self else { return }
                    var citys:[String] = []
                    if !isEmptyString(string2) {
                        citys.append(string2)
                    }
                    if !isEmptyString(string3) {
                        citys.append(string3)
                    }
                     detailInfo.schoolAddress.area = citys
                     loadInfo()
                     saveInfoSilent()
                }
                self.present(vc, animated: true)
            }
        }
    }
    
    func createDefaultCell(_ indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "UITableViewCell", for: indexPath)
        return cell
    }
        
    func createCorner(cell:UITableViewCell, arr:Array<Any>, indexPath:IndexPath) {
        // 设置每块section圆角
        if (indexPath.row == 0) {
            let corner = UIRectCorner(rawValue: UIRectCorner.topLeft.rawValue | UIRectCorner.topRight.rawValue)
            cell.createCorner(CGSizeMake(12.0, 12.0), corner)
            
        } else if (indexPath.row == arr.count-1) {
            let corner = UIRectCorner(rawValue: UIRectCorner.bottomLeft.rawValue | UIRectCorner.bottomRight.rawValue)
            cell.createCorner(CGSizeMake(12.0, 12.0), corner)
            
        } else {
            cell.layer.mask = nil
        }
    }
    
    func getCellType(_ item: Any) ->HKFormItemCellType {
        if item is YHFormTitleItem {
            return .title
        }
        
        if item is YHFormDetailItem {
            let detailItem = item as! YHFormDetailItem
            
            if detailItem.type == .educationCity {
                if detailInfo.isSchoolInAboard() {
                    return .inputText
                }
                return .selectSheet
            }
            
            if  detailItem.type == .educationMajor
            {
                return .inputText
            }
            if detailItem.type == .universityFullName
                || detailItem.type == .educationStyle
                || detailItem.type == .educationTime
                || detailItem.type == .graduateTime
                || detailItem.type == .educationDegree
                || detailItem.type == .degreeType
                || detailItem.type == .educationCountry
            {
                
                return .selectSheet
            }
        }
        return .defaultType
    }
}

extension YHEducationDetailVC {
    func getDetailInfo() {
        self.educationRequest.getEducationDetailInfo(params: ["id": self.detailId]) {
            [weak self] success, error in
            guard let self = self else { return }
            if success {
                if let educationDetailInfo = self.educationRequest.educationDetailInfo {
                    detailInfo = educationDetailInfo
                }
                loadInfo()
            }
        }
    }
    
    func submitInfo() {
        let isChecked = checkIntegrity()
        isNeedShowError = !isChecked
        
        self.tableView .reloadData()
        
        if !isChecked {
            YHHUD.flash(message: "资料还未填完")
            return
        }
        saveDetailInfo(isSubmit:true, isNeedPop: true, isShowToast: true)
    }
    
    // 检查填写信息完整性
    func checkIntegrity() -> Bool {
        
        if detailInfo.college.isEmpty
            || detailInfo.teachingFormat.isEmpty
            || detailInfo.admissionTime.isEmpty
            || detailInfo.graduateTime.isEmpty
            || detailInfo.major.isEmpty
            || detailInfo.degree.isEmpty
            || detailInfo.degreeType.isEmpty
            || detailInfo.schoolAddress.country.isEmpty
        {
            return false
        }
        
        if detailInfo.isSchoolInAboard(), detailInfo.schoolAddress.foreign.isEmpty {
            return false
        }
        
        if !detailInfo.isSchoolInAboard(), detailInfo.schoolAddress.area.count <= 0 {
            return false
        }
        return true
    }
    
    func saveInfoSilent() {
        if detailId != 0 {
            saveDetailInfo(isSubmit:false, isNeedPop: false, isShowToast: false)
        }
    }
    
    // 保存信息 isNeedPop：保存成功后是否退出该页面
    func saveDetailInfo(isSubmit:Bool, isNeedPop:Bool, isShowToast:Bool) {
        
        guard var dict:[String:Any] = detailInfo.toDictionary() else { return }
        dict["order_id"] = self.orderId
        dict["is_aboard_school"] = detailInfo.isSchoolInAboard()
    
        self.educationRequest.saveEducationInfo(params: dict, isSilent: !isShowToast) {
            [weak self] success, error in
            guard let self = self else { return }
            
            if success {
                if isShowToast {
                    YHHUD.flash(message: isSubmit ? "提交成功":"保存成功" )
                }
                if isNeedPop {
                    self.navigationController?.popViewController(animated: true)
                }
                
            } else {
                if isShowToast {
                    var errorMsg = isSubmit ? "提交失败" : "保存失败"
                    if let errMsg = error?.errorMsg, errMsg.count > 0 {
                        errorMsg = errMsg
                    }
                    YHHUD.flash(message: errorMsg)
                }
            }
        }
    }
}
