//
//  YHEducationalQualificationVC.swift
//  galaxy
//
//  Created by edy on 2024/2/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
//import Toast_Swift

class YHEducationInfoListVC: YHBaseViewController {
    
    var orderId:Int = 0
    let educationRequest:YHEducationRequestViewModel = YHEducationRequestViewModel()
    var familyMemberInfo: YHFamilyMemberGroupInfo?
    // 学历编辑模式
    var isDegreeEditMode: YHFormTitleItemEditType = .none
    // 专业编辑模式
    var isQualificationEditMode: YHFormTitleItemEditType = .none
    var educationInfo: YHEducationListInfo?
    var items:[[YHFormItemProtocol]] = []
    // 是否显示未填写错误提示
    var isNeedShowError = false
    
    lazy var tableView: UITableView = {
        
        let tableView = UITableView(frame:.zero, style:.grouped)
        
        if #available(iOS 11.0, *) {
            tableView.contentInsetAdjustmentBehavior = .never
        }
        tableView.estimatedSectionHeaderHeight = 14.0
        tableView.estimatedSectionFooterHeight = 1.0
        tableView.showsVerticalScrollIndicator = false
        tableView.backgroundColor = UIColor(hexString:"#F8F8F8")
        tableView.separatorStyle = .none
        tableView.delegate = self
        tableView.dataSource = self
        tableView.register(UITableViewCell.self, forCellReuseIdentifier: "UITableViewCell")
        tableView.register(YHEducationInfoCell.self, forCellReuseIdentifier: YHEducationInfoCell.cellReuseIdentifier)
        tableView.register(YHFormItemTitleCell.self, forCellReuseIdentifier: YHFormItemTitleCell.cellReuseIdentifier)
        tableView.register(YHFormItemAddCell.self, forCellReuseIdentifier: YHFormItemAddCell.cellReuseIdentifier)
        tableView.register(YHFormItemEnterDetailCell.self, forCellReuseIdentifier: YHFormItemEnterDetailCell.cellReuseIdentifier)
        tableView.register(YHFormItemAddCell.self, forCellReuseIdentifier: YHFormItemAddCell.cellReuseIdentifier)
        tableView.register(YHFormItemQuestionsCell.self, forCellReuseIdentifier: YHFormItemQuestionsCell.cellReuseIdentifier)
        return tableView
    }()
    
    var bottomView: YHSaveAndSubmitView = {
        let view = YHSaveAndSubmitView.createView()
        return view
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.gk_navTitle = "学历/专业资格填写".local
        self.gk_navigationBar.backgroundColor = .white
        view.backgroundColor = UIColor(hexString:"#F8F8F8")
        createUI()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        requestEducationInfo()
    }
    
    func createUI() {
        
        view.addSubview(tableView);
        view.addSubview(bottomView)
        
        bottomView.saveBlock = {
            [weak self] in
            guard let self = self else { return }
            saveInfo(isSubmit: false)
            self.navigationController?.popViewController(animated: true)
        }
        
        bottomView.submitBlock = {
            [weak self] in
            guard let self = self else { return }
            submitInfo()
        }
        
        bottomView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalToSuperview()
            make.height.equalTo(YHSaveAndSubmitView.height)
        }
        
        tableView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(k_Height_NavigationtBarAndStatuBar)
            make.bottom.equalTo(bottomView.snp.top)
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
        }
        
        loadInfo()
    }
    
    func loadInfo() {
        
        guard let educationInfo = educationInfo else { return }
        
        items.removeAll()
        
        // 主申请人学历
        let title0 = YHFormTitleItem(type: .mainApplicantEducation)
        var arr0:[YHFormItemProtocol] = [title0]
        if let eduList = educationInfo.eduList {
            for (index, eduInfo) in eduList.enumerated() {
                let item = YHFormDetailItem(type: .educationInfo)
                arr0.append(item)
            }
            // 多学历可编辑删除状态
            if eduList.count <= 1 {
                isDegreeEditMode = .none
            } else {
                if isDegreeEditMode == .none {
                    isDegreeEditMode = .canEdit
                }
            }
        } else {
            isDegreeEditMode = .none
        }
        // 新增学历信息
        arr0.append(YHFormAddItem(type: .addEducation))
        items.append(arr0)
        
        // 主申请人专业资格及会员资格
        let title1 = YHFormTitleItem(type: .mainApplicantProfessionalQualification)
        var arr1:[YHFormItemProtocol] = [title1]
        if let quaList = educationInfo.quaList {
            for (index, quaInfo) in quaList.enumerated() {
                let item = YHFormDetailItem(type: .certificateInfo)
                arr1.append(item)
            }
            // 多专业可编辑删除状态
            if quaList.count <= 0 {
                isQualificationEditMode = .none
            } else {
                if isQualificationEditMode == .none {
                    isQualificationEditMode = .canEdit
                }
            }
        } else {
            isQualificationEditMode = .none
        }
        
        // 新增学历信息
        arr1.append(YHFormAddItem(type: .addCertificateInfo))
        items.append(arr1)
        
        // 学历证书姓名及出生日期正确性
        let title2 = YHFormTitleItem(type: .edutionalCertificateNameAndBirthday)
        var arr2:[YHFormItemProtocol] = [title2]
        // 问题集合
        let questions = YHQuestionInfo.getEducationQuestion(eduList: educationInfo)
        for questionInfo in questions {
            if questionInfo.key == "qualification" {
                questionInfo.answer = educationInfo.isNameSame
                
            } else if questionInfo.key == "graduate" {
                questionInfo.answer = educationInfo.isSpouseNameSame
            }
            arr2.append(questionInfo)
        }
        items.append(arr2)
        
        
        self.tableView.reloadData()
    }
}

extension YHEducationInfoListVC : UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return items.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if section >= items.count { return 0 }
        let arr = items[section]
        return arr.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        if indexPath.section >= items.count { return createDefaultCell(indexPath) }
        let arr:[YHFormItemProtocol] = items[indexPath.section]
        if indexPath.row >= arr.count {  return createDefaultCell(indexPath) }
        let item:YHFormItemProtocol = arr[indexPath.row]

        if item is YHFormTitleItem { // 是标题
            
            let formItem = item as! YHFormTitleItem
            
            let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemTitleCell.cellReuseIdentifier, for: indexPath) as! YHFormItemTitleCell
            let isNeedWrap = (formItem.type == .mainApplicantProfessionalQualification)
            cell.setTitleAndSubTitle(title:formItem.getTitle(), subTitle:formItem.getSubTitle(), isNeedWrap:isNeedWrap)

            // 决定右边按钮显示样式
            cell.showEditType(type: .none)
            if formItem.type == .mainApplicantEducation { // 学历
                cell.showEditType(type: isDegreeEditMode)
                
            } else if formItem.type == .mainApplicantProfessionalQualification { // 专业
                cell.showEditType(type: isQualificationEditMode)
            }
            
            // 右边按钮点击事件处理
            cell.rightClickBlock = { 
                [weak self] type in
                guard let self = self else { return }
                if formItem.type == .mainApplicantEducation {  // 学历
                    if self.isDegreeEditMode == .canCancel {
                        self.isDegreeEditMode = .canEdit
                        
                    } else if self.isDegreeEditMode == .canEdit {
                        self.isDegreeEditMode = .canCancel
                    }
                }
                if formItem.type == .mainApplicantProfessionalQualification {  // 专业
                    if self.isQualificationEditMode == .canCancel {
                        self.isQualificationEditMode = .canEdit
                        
                    } else if self.isQualificationEditMode == .canEdit {
                        self.isQualificationEditMode = .canCancel
                    }
                }
                loadInfo()
            }
            return cell
        }
        
        if item is YHFormAddItem {
            let detailItem = item as! YHFormAddItem
            let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemAddCell.cellReuseIdentifier, for: indexPath) as! YHFormItemAddCell
            if detailItem.type == .addEducation {
                cell.title = "新增学历信息"
                
            } else if detailItem.type == .addCertificateInfo {
                cell.title = "新增证书信息"
                
            } else {
                cell.title = ""
            }
            
            cell.clickBlock = {
                
                [weak self]  in
                guard let self = self else { return }
                
                if detailItem.type == .addEducation { // 学历
                    let vc = YHEducationDetailVC()
                    vc.orderId = self.orderId
                    self.navigationController?.pushViewController(vc)
                    
                } else if detailItem.type == .addCertificateInfo { // 证书
                    let vc = YHQualificationDetailVC()
                    vc.orderId = self.orderId
                    self.navigationController?.pushViewController(vc)
                }
                return
            }
            return cell
        }
        
        if item is YHQuestionInfo {
            
            let detailItem = item as! YHQuestionInfo
            let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemQuestionsCell.cellReuseIdentifier, for: indexPath) as! YHFormItemQuestionsCell
            cell.isMust = true
            cell.title =  String(format: "%d、\(detailItem.question)", indexPath.row)
            
            var select0 = false
            var select1 = false
            if let answer = detailItem.answer {
                select0 = answer
                select1 = !answer
            }
            
            let answers = [YHFormChoiceItem(title: "是".local, isSelect: select0),YHFormChoiceItem(title: "否".local, isSelect: select1)]
            cell.answerArr = answers
            cell.answerBlock = {
                
                [weak self]  (arr, selectIndex) in
                guard let self = self else { return }
                
                let selectItem:YHFormChoiceItem = arr[selectIndex]
                let option = (selectItem.title == "是".local ? true : false)
                if detailItem.key == "qualification" {
                    self.educationInfo?.isNameSame = option
                    
                } else if detailItem.key == "graduate" {
                    self.educationInfo?.isSpouseNameSame = option
                }
                loadInfo()
            }
            return cell
        }
        
        if item is YHFormDetailItem {
            let detailItem = item as! YHFormDetailItem
            if detailItem.type == .educationInfo {
                if let eduList = educationInfo?.eduList, eduList.count > 0 {
                    // 第一行是标题
                    let eduInfo:YHEducationInfo = eduList[indexPath.row-1]
                    
                    if eduInfo.vacantNum > 0 { // 有未填项
                        let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemEnterDetailCell.cellReuseIdentifier, for: indexPath) as! YHFormItemEnterDetailCell
                        if let college = eduInfo.college, !college.isEmpty {
                            cell.title = eduInfo.college
                        } else {
                            cell.title = "学历标题".local
                        }
                        let tips = String(format: "有%d项未填", eduInfo.vacantNum)
                        cell.detailLabel.text = tips
                        cell.isShowDeleteBtn = (isDegreeEditMode == .canCancel && eduList.count > 1)
                        cell.setTips(tips, isShow:(isNeedShowError && eduInfo.vacantNum > 0))
                        cell.deleteBlock = {
                            var title = "确定删除该学历吗?"
                            if let collegeName = eduInfo.college, !collegeName.isEmpty {
                                title = "确定删除学历\(collegeName)吗"
                            }
                            YHTwoOptionAlertView.showAlertView(message:title) {
                                [weak self] sure in
                                guard let self = self else { return }
                                if !sure { return }
                                isDegreeEditMode = .none
                                deleteEducationInfo(id:eduInfo.id)
                            }
                        }
                        return cell
                        
                    } else { // 数据已填满
                        
                        let cell = tableView.dequeueReusableCell(withIdentifier: YHEducationInfoCell.cellReuseIdentifier, for: indexPath) as! YHEducationInfoCell
                        cell.titleLabel.text = eduInfo.college
                        cell.subTitleLabel.text = ""
                        if let major = eduInfo.major, let degree = eduInfo.degree {
                            cell.subTitleLabel.text = String("\(degree)-\(major)")
                        }
                        cell.timeLabel.text = ""
                        if let admissionTime = eduInfo.admissionTime, let graduateTime = eduInfo.graduateTime {
                            cell.timeLabel.text = String("\(admissionTime)-\(graduateTime)")
                        }
                        cell.isShowDeleteBtn = (isDegreeEditMode == .canCancel)
                        cell.deleteBlock = {
                            var title = "确定删除该学历吗?"
                            if let collegeName = eduInfo.college, !collegeName.isEmpty {
                                title = "确定删除学历\(collegeName)吗"
                            }
                            YHTwoOptionAlertView.showAlertView(message:title) {
                                [weak self] sure in
                                guard let self = self else { return }
                                if !sure { return }
                                isDegreeEditMode = .none
                                deleteEducationInfo(id:eduInfo.id)
                            }
                        }
                        return cell
                    }
                }
            }
            if detailItem.type == .certificateInfo {
                if let quaList = educationInfo?.quaList, quaList.count > 0 {
                    // 第一行是标题
                    let quaInfo:YHQualificationInfo = quaList[indexPath.row-1]
                    let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemEnterDetailCell.cellReuseIdentifier, for: indexPath) as! YHFormItemEnterDetailCell
                    cell.title = "证书标题"
                    if let qualification = quaInfo.qualification, !qualification.isEmpty {
                        cell.title = qualification
                    }
                    var tips = ""
                    if quaInfo.vacantNum > 0 {
                        tips = String(format: "有%d项未填", quaInfo.vacantNum)
                        cell.detailLabel.text = tips
                    } else {
                        cell.detailLabel.text = "已填完".local
                    }
                    cell.setTips(tips, isShow:(isNeedShowError && quaInfo.vacantNum > 0))

                    cell.isShowDeleteBtn = (isQualificationEditMode == .canCancel)
                    cell.deleteBlock = {
                        var title = "确定要删除该证书吗?"
                        if let qualification = quaInfo.qualification, !qualification.isEmpty {
                            title = "确定删除证书\(qualification)吗"
                        }

                        YHTwoOptionAlertView.showAlertView(message:title) {
                            [weak self] sure in
                            guard let self = self else { return }
                            if !sure { return }
                            isQualificationEditMode = .none
                            deleteQualificationInfo(id:quaInfo.id)
                        }
                    }
                    return cell
                }
            }
        }
        
        let cell = tableView.dequeueReusableCell(withIdentifier: "UITableViewCell", for: indexPath)
        return cell
    }
    
    func tableView(_ tableView: UITableView, willDisplay cell: UITableViewCell, forRowAt indexPath: IndexPath) {
        
        if indexPath.section >= items.count { return  }
        let arr:[YHFormItemProtocol] = items[indexPath.section]
        if indexPath.row >= arr.count {  return }
        
        createCorner(cell: cell, arr: arr, indexPath: indexPath)
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        
        return UIView()
    }
    
    private func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> CGFloat {
        return 14.0
    }
    
    private func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> CGFloat {
        if section == items.count-1 {
            return 14.0
        }
        return 1.0
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
        let arr = items[indexPath.section]
        let item:YHFormItemProtocol = arr[indexPath.row]
        
        // 标题
        if item is YHFormTitleItem {
            return
        }
        
        if item is YHFormAddItem {
            return
        }
        
        if item is YHFormDetailItem {
            let detailItem = item as! YHFormDetailItem
            if detailItem.type == .educationInfo { // 学历
                let vc = YHEducationDetailVC()
                if let eduList = educationInfo?.eduList, indexPath.row-1 < eduList.count {
                    let eduInfo = eduList[indexPath.row-1]
                    vc.detailId = eduInfo.id
                    vc.orderId = self.orderId
                }
                self.navigationController?.pushViewController(vc)
                return
            }
            if detailItem.type == .certificateInfo { // 证书
                let vc = YHQualificationDetailVC()
                if let quaList = educationInfo?.quaList, indexPath.row-1 < quaList.count {
                    let quaInfo = quaList[indexPath.row-1]
                    vc.detailId = quaInfo.id
                    vc.orderId = self.orderId
                }
                self.navigationController?.pushViewController(vc)
                return
            }
        }
    }
    
    func createDefaultCell(_ indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "UITableViewCell", for: indexPath)
        return cell
    }
        
    func createCorner(cell:UITableViewCell, arr:Array<Any>, indexPath:IndexPath) {
        // 设置每块section圆角
        if (indexPath.row == 0) {
            let corner = UIRectCorner(rawValue: UIRectCorner.topLeft.rawValue | UIRectCorner.topRight.rawValue)
            cell.createCorner(CGSizeMake(12.0, 12.0), corner)
            
        } else if (indexPath.row == arr.count-1) {
            let corner = UIRectCorner(rawValue: UIRectCorner.bottomLeft.rawValue | UIRectCorner.bottomRight.rawValue)
            cell.createCorner(CGSizeMake(12.0, 12.0), corner)
            
        } else {
            cell.layer.mask = nil
        }
    }
}

extension YHEducationInfoListVC {
    
    // 请求家庭成员信息
    func requestEducationInfo() {
        
        self.educationRequest.requestEducationInfoList(params: ["order_id": self.orderId]) {
            [weak self] success, error in
            guard let self = self else { return }
            if success {
                educationInfo = self.educationRequest.listInfo
                loadInfo()
            }
        }
    }
    
    // 删除学历信息
    func deleteEducationInfo(id:Int) {
        
        self.educationRequest.deleteEducationInfo(id: id) {
            [weak self] success, error in
            guard let self = self else { return }
            if success {
                YHHUD.flash(message: "删除成功")
                requestEducationInfo()
            } else {
                var errorMsg = "删除失败"
                if let errMsg = error?.errorMsg, errMsg.count > 0 {
                    errorMsg = errMsg
                }
                YHHUD.flash(message: errorMsg)
            }
        }
    }
    
    // 删除证书信息
    func deleteQualificationInfo(id:Int) {
        
        self.educationRequest.deleteQualificationInfo(id: id) {
            [weak self] success, error in
            guard let self = self else { return }
            if success {
                YHHUD.flash(message: "删除成功")
                requestEducationInfo()
            } else {
                var errorMsg = "删除失败"
                if let errMsg = error?.errorMsg, errMsg.count > 0 {
                    errorMsg = errMsg
                }
                YHHUD.flash(message: errorMsg)
            }
        }
    }
    
    // 保存
    func saveInfo(isSubmit:Bool) {
        
        guard let educationInfo = educationInfo else { return }
        let params:[String : Any] = [ "order_id": self.orderId,
                                      "goNextFlow": isSubmit,
                                      "isSpouseNameSame": educationInfo.isSpouseNameSame ?? false,
                                      "isNameSame": educationInfo.isNameSame ?? false]
        
        self.educationRequest.saveAllEducationInfo(params: params) {
            [weak self] success, error in
            guard let self = self else { return }
            if success {
                requestEducationInfo()
                self.navigationController?.popViewController()
            } else {
                var errorMsg = isSubmit ? "提交失败" : "保存失败"
                if let errMsg = error?.errorMsg, errMsg.count > 0 {
                    errorMsg = errMsg
                }
                YHHUD.flash(message: errorMsg)
            }
        }
    }
    
    func submitInfo() {
        let isChecked = checkIntegrity()
        isNeedShowError = !isChecked
        self.tableView .reloadData()
        
        if !isChecked {
            YHHUD.flash(message: "资料还未填完")
            return
        }
        saveInfo(isSubmit: true)
    }
    
    // 检查填写信息完整性
    func checkIntegrity() -> Bool {
        
        guard let educationInfo = educationInfo else { return false }
        // 检查所有学历信息是否有未填项
        if let eduList = educationInfo.eduList, eduList.count > 0 {
            for eduInfo in eduList {
                if eduInfo.vacantNum > 0 {
                    return false
                }
            }
        }
        // 检查所有证书信息是否有未填项
        if let quaList = educationInfo.quaList, quaList.count > 0 {
            for quaInfo in quaList {
                if quaInfo.vacantNum > 0 {
                    return false
                }
            }
        }
        
        // 检查所有问题是否有未答项
        if educationInfo.isNameSame == nil || educationInfo.isSpouseNameSame == nil {
            return false
        }
        return true
        
    }
}


