//
//  YHQuestionInfo.swift
//  galaxy
//
//  Created by edy on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHQuestionInfo: SmartCodable, YHFormItemProtocol {
    
    var key: String = ""
    var question: String = ""
    var answer: Bool?
    
    enum CodingKeys: String, CodingKey {
        case key = "key"
        case question = "question"
        case answer = "answer"
    }

    required init() {
        
    }
    
    func getTitle() -> String {
        return question
    }
    
    func getSubTitle() -> String {
        return ""
    }
}

extension YHQuestionInfo {

   // 【问题】学历证书姓名及出生日期正确性
    static func getEducationQuestion(eduList:YHEducationListInfo) -> [YHQuestionInfo] {
        let path = Bundle.main.path(forResource: "YHQuestionList", ofType: "plist")
        let questions:[Dictionary] = NSArray(contentsOfFile:path!) as! [Dictionary<String, Any>]
        var res:[YHQuestionInfo] = []
        for dict in questions {
            guard let questionInfo = YHQuestionInfo.deserialize(dict: dict as? [AnyHashable : Any]) else {
                continue
            }
            if questionInfo.key == "graduate" {
                if eduList.isMarried() {
                    res.append(questionInfo)
                }
            } else {
                res.append(questionInfo)
            }
        }
        return res
    }
}
