//
//  YHFormPickerViewType.swift
//  galaxy
//
//  Created by edy on 2024/2/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

enum YHFormPickerViewType: Int {
    // 按自然顺序递增
    case none = 0
    // 学位
    case degree
    // 学位有无
    case ownDegree
    // 婚姻
    case marriage
    // 授课形式
    case edution
    // 职业
    case occupation
    // 职业2
    case profession
    // 性别
    case gender
    // 证件
    case certificate
    // 在港身份
    case identity
    // 颁发地区
    case degreeLocation
    // 专业证书
    case professionCertificate
    // 学位类型
    case degreeCategory
}

enum YHPickerViewMarriageType: Int {
    // 未婚
    case unmarriage = 0
    // 已婚
    case marriaged = 1
    // 离婚
    case divorced = 2
    // 分居
    case separated = 3
    // 丧偶
    case widowed = 4
}

enum YHPickerViewDegreeType:Int {
    // 学士
    case bachelor = 1
    // 硕士
    case master = 2
    // 博士
    case doctor = 3
}

enum YHPickerViewEducationType {
    // 全日制
    case fullTime
    // 兼读制
    case partTime
    // 遥距课程
    case distanceCourses
}

enum YHPickerViewOccupationType {
    // 在职
    case onTheJob
    // 退休
    case retire
    // 无业
    case unemployed
    // 学生
    case student
}

enum YHPicerViewProfessionType: Int {
    // 企业管理者 (高级管理者)
    case enterpriseManagerSenior = 0
    // 企业管理者 (包括初、中级层管理者)
    case enterpriseManagerJunior
    // 自主创业 (有实际运营的公司)
    case startOwnBusiness
    // 普通职员 (办公室/写字楼)
    case generalStaff
    // 专业人员 (医生/教师/律师/记者/文体)
    case professionals
    // 个体经营/承包商
    case selfEmployed
    // 政府机关干部/公务人员
    case governmentEmployee
    // 在校学生
    case student
    // 家庭主妇
    case houseWife
    // 退休人员
    case retirees
    // 应届毕业生
    case graduates
    // 其他
    case other
}

enum YHPickerViewGenderType: Int {
    // 男
    case male = 1
    // 女
    case female = 2
}

enum YHPickerViewCertificateType: Int {
    // 护照
    case passport = 3
    // 外交护照
    case diplomaticPassport = 4
    // 公务护照
    case officialPassport = 5
    // 中国发无国籍旅游证件
    case chineseStatelessTravelPassport = 6
    // 旅游通行证
    case travelPassport = 7
    // 联合国通行证
    case unitedNationsPassport = 8
    // 其他无国籍旅行证件
    case otherStatelessTravelPassport = 9
    // 其他
    case other = 10

}

enum YHPickerViewIdentityType: Int {
    // 学生
    case student = 0
    // 就业
    case employment = 1
    // 居留
    case residence = 2
    // 访问
    case visit = 3
    // 其他
    case other = 4
}

enum YHPickerViewHasDegreeType: Int {
    // 无学位
    case noDegree = 0
    // 有学位
    case hasDegree = 1
}

enum YHPickerViewDegreeLocationType:Int {
    // 国内
    case domestic = 1
    // 国外
    case forgin = 2
}

enum YHPickerViewProfessionalCertificateType:Int {
    // CFA(注册金融分析师)
    case CFA = 0
    // CFP(CFP证书是目前世界上权威的权威理财顾问认证项目之一)
    case CFP
    // FRM(金融风险管理师)
    case FRM
    // FIA(保险精算师)
    case FIA
    // CPA(注册会计师)
    case CPA
    // CIIA(注册国际投资分析师)
    case CIIA
    // RFC(财务顾问师)
    case RFC
    // ACCA(特许公认会计师)
    case ACCA
    // CIA(国际注册内部审计师)
    case CIA
    // CMA(美国管理会计师)
    case CMA
    // CQF(国际数量金融工程认证)
    case CQF
    // CIMA(管理会计师考试)
    case CIMA
    // The Associate Chartered Accountant(英国皇家特许会计师)
    case ACA
}

enum YHPickerViewDegreedegreeCategoryType:Int {
    // 会计/金融
    case accountantOrFinance
    // 艺术及人文/文学
    case artOrLiterature
    // 工商管理
    case businessManagement
    // 经济学
    case economics
    // 工程学
    case engineering
    // 咨询科技/电子及软件工程/数据科学
    case electronicOrSoftwareEngineering
    // 法律
    case laws
    // 生命科学及医学
    case lifeSciencesOrMedicine
    // 管理学
    case management
    // 理学
    case NeoConfucianism
    // 社会科学
    case socialScience
    // 其他
    case others

}

enum YHFormPickerViewSubType {
    
    case none
    case marriage(YHPickerViewMarriageType)
    case degree(YHPickerViewDegreeType)
    case ownDegree(YHPickerViewHasDegreeType)
    case education(YHPickerViewEducationType)
    case occupation(YHPickerViewOccupationType)
    case gender(YHPickerViewGenderType)
    case certificate(YHPickerViewCertificateType)
    case identity(YHPickerViewIdentityType)
    case degreeLocation(YHPickerViewDegreeLocationType)
    case profession(YHPicerViewProfessionType)
    case professionCertificate(YHPickerViewProfessionalCertificateType)
    case degreeCategory(YHPickerViewDegreedegreeCategoryType)
    
    var title:String {
        switch self {
            
        case .none:
            return "".local
            
        case .ownDegree(.hasDegree):
            return "有学位".local
        case .ownDegree(.noDegree):
            return "无学位".local
            
        case .marriage(.unmarriage):
            return "未婚".local
        case .marriage(.marriaged):
            return "已婚".local
        case .marriage(.separated):
            return "分居".local
        case .marriage(.divorced):
            return "离婚".local
        case .marriage(.widowed):
            return "丧偶".local
            
        case .degree(.bachelor):
            return "学士学位".local
        case .degree(.master):
            return "硕士学位".local
        case .degree(.doctor):
            return "博士学位".local
            
        case .education(.fullTime):
            return "全日制".local
        case .education(.partTime):
            return "兼职制".local
        case.education(.distanceCourses):
            return "遥距课程".local
            
        case .occupation(.onTheJob):
            return "在职".local
        case .occupation(.retire):
            return "退休".local
        case .occupation(.unemployed):
            return "无业".local
        case .occupation(.student):
            return "学生".local
            
        case .gender(.male):
            return "男".local
        case .gender(.female):
            return "女".local
            
        case .certificate(.passport):
            return "护照".local
        case .certificate(.travelPassport):
            return "旅游通行证".local
        case .certificate(.diplomaticPassport):
            return "外交护照".local
        case .certificate(.chineseStatelessTravelPassport):
            return "中国发无国籍旅游证件".local
        case .certificate(.otherStatelessTravelPassport):
            return "其他无国籍旅行证件".local
        case .certificate(.unitedNationsPassport):
            return "联合国通行证".local
        case .certificate(.officialPassport):
            return "公务护照".local
        case .certificate(.other):
            return "其他".local
            
        case .identity(.student):
            return "学生".local
        case .identity(.employment):
            return "就业".local
        case .identity(.residence):
            return "居留".local
        case .identity(.visit):
            return "访问".local
        case .identity(.other):
            return "其他".local
            
        case .degreeLocation(.domestic):
            return "国内 (颁发)".local
        case .degreeLocation(.forgin):
            return "国外 (颁发)".local
            
        case .profession(.enterpriseManagerSenior):
            return "企业管理者 (高级管理者)".local
        case .profession(.enterpriseManagerJunior):
            return "企业管理者 (包括初、中级层管理者)".local
        case .profession(.startOwnBusiness):
            return "自主创业 (有实际运营的公司)".local
        case .profession(.generalStaff):
            return "普通职员 (办公室/写字楼)".local
        case .profession(.professionals):
            return "专业人员 (医生/教师/律师/记者/文体)".local
        case .profession(.selfEmployed):
            return "个体经营/承包商".local
        case .profession(.governmentEmployee):
            return "政府机关干部/公务人员".local
        case .profession(.student):
            return "在校学生".local
        case .profession(.houseWife):
            return "家庭主妇".local
        case .profession(.retirees):
            return "退休人员".local
        case .profession(.graduates):
            return "应届毕业生".local
        case .profession(.other):
            return "其他".local
            
        case .professionCertificate(.CFA):
            return "CFA(注册金融分析师)".local
        case .professionCertificate(.CFP):
            return "CFP(CFP证书是目前世界上权威的权威理财顾问认证项目之一)".local
        case .professionCertificate(.FRM):
            return "FRM(金融风险管理师)".local
        case .professionCertificate(.FIA):
            return "FIA(保险精算师)".local
        case .professionCertificate(.CPA):
            return "CPA(注册会计师)".local
        case .professionCertificate(.CIIA):
            return "CIIA(注册国际投资分析师)".local
        case .professionCertificate(.RFC):
            return "RFC(财务顾问师)".local
        case .professionCertificate(.ACCA):
            return "ACCA(特许公认会计师)".local
        case .professionCertificate(.CIA):
            return "CIA(国际注册内部审计师)".local
        case .professionCertificate(.CMA):
            return "CMA(美国管理会计师)".local
        case .professionCertificate(.CQF):
            return "CQF(国际数量金融工程认证)".local
        case .professionCertificate(.CIMA):
            return "CIMA(管理会计师考试)".local
        case .professionCertificate(.ACA):
            return "The Associate Chartered Accountant(英国皇家特许会计师)".local
            
        case .degreeCategory(.accountantOrFinance):
            return "会计/金融".local
        case .degreeCategory(.artOrLiterature):
            return "艺术及人文/文学".local
        case .degreeCategory(.businessManagement):
            return "工商管理".local
        case .degreeCategory(.economics):
            return "经济学".local
        case .degreeCategory(.engineering):
            return "工程学".local
        case .degreeCategory(.electronicOrSoftwareEngineering):
            return "咨询科技/电子及软件工程/数据科学".local
        case .degreeCategory(.laws):
            return "法律".local
        case .degreeCategory(.lifeSciencesOrMedicine):
            return "生命科学及医学".local
        case .degreeCategory(.management):
            return "管理学".local
        case .degreeCategory(.NeoConfucianism):
            return "理学".local
        case .degreeCategory(.socialScience):
            return "社会科学".local
        case .degreeCategory(.others):
            return "其他".local
            
        }
    }
    
    var index:Int {
        
        switch self {
            
        case .none:
            return 0
            
        case .marriage(.unmarriage):
            return 0
        case .marriage(.marriaged):
            return 1
        case .marriage(.separated):
            return 2
        case .marriage(.divorced):
            return 3
        case .marriage(.widowed):
            return 4
            
        case .degree(.bachelor):
            return 1
        case .degree(.master):
            return 2
        case .degree(.doctor):
            return 3
            
        case .education(.fullTime):
            return 0
        case .education(.partTime):
            return 1
        case.education(.distanceCourses):
            return 2
            
        case .occupation(.onTheJob):
            return 0
        case .occupation(.retire):
            return 1
        case .occupation(.unemployed):
            return 2
        case .occupation(.student):
            return 3
            
        case .gender(.male):
            return 0
        case .gender(.female):
            return 1
            
        case .certificate(.passport):
            return 3
        case .certificate(.diplomaticPassport):
            return 4
        case .certificate(.officialPassport):
            return 5
        case .certificate(.chineseStatelessTravelPassport):
            return 6
        case .certificate(.travelPassport):
            return 7
        case .certificate(.unitedNationsPassport):
            return 8
        case .certificate(.otherStatelessTravelPassport):
            return 9
        case .certificate(.other):
            return 10
            
        case .ownDegree(.noDegree):
            return 0
        case .ownDegree(.hasDegree):
            return 1
            
        case .identity(.student):
            return 0
        case .identity(.employment):
            return 1
        case .identity(.residence):
            return 2
        case .identity(.visit):
            return 3
        case .identity(.other):
            return 4
            
        case .degreeLocation(.domestic):
            return 1
        case .degreeLocation(.forgin):
            return 2
            
        case .profession(.enterpriseManagerSenior):
            return 0
        case .profession(.enterpriseManagerJunior):
            return 1
        case .profession(.startOwnBusiness):
            return 2
        case .profession(.generalStaff):
            return 3
        case .profession(.professionals):
            return 4
        case .profession(.selfEmployed):
            return 5
        case .profession(.governmentEmployee):
            return 6
        case .profession(.student):
            return 7
        case .profession(.houseWife):
            return 8
        case .profession(.retirees):
            return 9
        case .profession(.graduates):
            return 10
        case .profession(.other):
            return 11
            
        case .professionCertificate(.CFA):
            return 1
        case .professionCertificate(.CFP):
            return 2
        case .professionCertificate(.FRM):
            return 3
        case .professionCertificate(.FIA):
            return 4
        case .professionCertificate(.CPA):
            return 5
        case .professionCertificate(.CIIA):
            return 6
        case .professionCertificate(.RFC):
            return 7
        case .professionCertificate(.ACCA):
            return 8
        case .professionCertificate(.CIA):
            return 9
        case .professionCertificate(.CMA):
            return 10
        case .professionCertificate(.CQF):
            return 11
        case .professionCertificate(.CIMA):
            return 12
        case .professionCertificate(.ACA):
            return 13
            
        case .degreeCategory(.accountantOrFinance):
            return 0
        case .degreeCategory(.artOrLiterature):
            return 1
        case .degreeCategory(.businessManagement):
            return 2
        case .degreeCategory(.economics):
            return 3
        case .degreeCategory(.engineering):
            return 4
        case .degreeCategory(.electronicOrSoftwareEngineering):
            return 5
        case .degreeCategory(.laws):
            return 6
        case .degreeCategory(.lifeSciencesOrMedicine):
            return 7
        case .degreeCategory(.management):
            return 8
        case .degreeCategory(.NeoConfucianism):
            return 9
        case .degreeCategory(.socialScience):
            return 10
        case .degreeCategory(.others):
            return 11

        }
    }
}
