//
//  YHFormItemExpireDateCell.swift
//  galaxy
//
//  Created by edy on 2024/1/27.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFormItemExpireDateCell: UITableViewCell {

    static let cellReuseIdentifier = "YHFormItemExpireDateCell"
    
    private let horizonalGap = 18.0
    private let detailColor = UIColor.mainTextColor
    private let placeHolderColor = UIColor.placeHolderColor
    let longTimeBtnWidth = 44.0
    // 是否必填 如必填title会展示红色*
    var isMust = false
    var placeHolder:String? = "请选择"

    var clickBlock:((Bool)->Void)?
    // 是否隐藏顶部分割线
    var isHiddenTopLine:Bool = false {
        didSet {
            topLine.isHidden = isHiddenTopLine
        }
    }

    var title:String? {
        didSet {
            if let title = title, !title.isEmpty {
                let str = (isMust ? ("*"+title) : title)
                let attributes: [NSAttributedString.Key: Any] = [
                    .font: UIFont.PFSC_R(ofSize: 14),
                    .foregroundColor: UIColor.mainTextColor]
                let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
                if isMust {
                    let starRange = NSRange(location: 0, length: 1)
                    questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
                }
                titleLabel.attributedText = questionAttrStr
            } else {
                titleLabel.attributedText = nil
            }
        }
    }
    
    var isLongTime:Bool = false {
        didSet {
            updateUI()
        }
    }
    
    var detail:String? {
        didSet {
            if let detail = detail, !detail.isEmpty {
                detailLabel.text =  detail
                detailLabel.textColor = detailColor
            } else {
                detailLabel.text = placeHolder
                detailLabel.textColor = placeHolderColor
            }
        }
    }

    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor(hexString:"#333333")
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        return label
    }()
    
    private lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .left
        label.font = UIFont.PFSC_M(ofSize: 14)
        return label
    }()

    
    lazy var longTimeBtn: UIButton = {
        let btn = UIButton(type: .custom)
        btn.setTitle("长期".local, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(UIColor.mainTextColor, for: .normal)
        btn.iconInLeft(spacing: 6)
        let unselectImg = UIImage(named: "login_privacy_disagree")
        let selectImg = UIImage(named: "login_privacy_agree")
        btn.setImage(unselectImg, for: .normal)
        btn.setImage(selectImg, for: .selected)
        return btn
    }()
    
    // 增大点击区域
    lazy var longAreaBtn: UIButton = {
        let btn = UIButton()
        btn.addTarget(self, action: #selector(didClickLongTimeBtn), for: .touchUpInside)
        return btn
    }()
    
    private lazy var tipsLabel: UILabel = {
        let label = UILabel()
        label.textColor = .failColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.isHidden = true
        return label
    }()
    
    private lazy var topLine:UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = .white

        detail = ""
        
        contentView.addSubview(titleLabel)
        contentView.addSubview(detailLabel)
        contentView.addSubview(longTimeBtn)
        contentView.addSubview(longAreaBtn)
        contentView.addSubview(tipsLabel)
        contentView.addSubview(topLine)

        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(horizonalGap)
            make.right.equalTo(detailLabel.snp.left).offset(-6)
            make.width.equalTo(120)
            make.top.equalToSuperview().offset(horizonalGap)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-longTimeBtnWidth-horizonalGap-6)
            make.top.equalTo(titleLabel)
        }
        
        longTimeBtn.snp.makeConstraints { make in
            make.size.equalTo(CGSizeMake(longTimeBtnWidth, 40))
            make.right.equalToSuperview().offset(-horizonalGap)
            make.centerY.equalTo(titleLabel)
        }
        
        longAreaBtn.snp.makeConstraints { make in
            make.center.equalTo(longTimeBtn.snp.center)
            make.size.equalTo(CGSizeMake(longTimeBtnWidth+20, 40))
        }
        
        topLine.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(horizonalGap)
            make.right.equalToSuperview().offset(-horizonalGap)
            make.height.equalTo(1.0)
            make.top.equalToSuperview()
        }
        
        setTips("", isShow: false)
    }
    
    func setTips(_ tips:String?, isShow:Bool) {
        tipsLabel.text = tips
        tipsLabel.isHidden = !isShow
        if isShow {
            tipsLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(horizonalGap)
                make.right.equalToSuperview().offset(-horizonalGap)
                make.top.equalTo(titleLabel.snp.bottom).offset(6)
                make.bottom.equalToSuperview().offset(-16)
            }
        } else {
            tipsLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(horizonalGap)
                make.right.equalToSuperview().offset(-horizonalGap)
                make.top.equalTo(titleLabel.snp.bottom)
                make.height.equalTo(0)
                make.bottom.equalToSuperview().offset(-16)
            }
        }
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }
    
    func updateUI() {
    
        detailLabel.isHidden = isLongTime
        if isLongTime {
            tipsLabel.isHidden = true
        } else {
            tipsLabel.isHidden = !isEmptyString(detail)
        }
        longTimeBtn.isSelected = isLongTime
        longTimeBtn.snp.remakeConstraints { make in
            make.size.equalTo(CGSizeMake(longTimeBtnWidth, 40))
            make.centerY.equalTo(titleLabel)
            if isLongTime {
                make.left.equalTo(detailLabel)
            } else {
                make.right.equalToSuperview().offset(-16)
            }
        }
    }
    
    @objc func didClickLongTimeBtn() {
     
        isLongTime = !isLongTime
    
        if let clickBlock = clickBlock {
            clickBlock(isLongTime)
        }
    }
}
