//
//  YHOtherResidenceFillView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHOtherResidenceFillView: UIView {
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    var dataModel : Residence? {
        didSet {
            updateUI()
        }
    }
    
    let nationView : YHOtherSelecteItemView =  YHOtherSelecteItemView()
    let startView : YHOtherSelecteItemView =  YHOtherSelecteItemView()
    let endView : YHOtherSelecteItemView =  YHOtherSelecteItemView()
    
    
    override func layoutSubviews() {
        super.layoutSubviews()
        
        nationView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
        }
        
        startView.snp.makeConstraints { make in
            make.top.equalTo(nationView.snp.bottom)
            make.left.right.equalToSuperview()
        }
        
        
        endView.showLongTimeButtonFlag = true
        endView.block = {[weak self] flag, text in
            guard let self = self else { return }
            self.endView.updateKeyName(name: "结束时间", keyValue: "")
            self.dataModel?.end_time = text
            
            if flag {
                self.dataModel?.end_time_checked = true
            } else {
                self.dataModel?.end_time_checked = false
            }
            self.layoutIfNeeded()
        }
        endView.snp.makeConstraints { make in
            make.top.equalTo(startView.snp.bottom)
            make.left.right.equalToSuperview()
            make.bottom.equalToSuperview()
        }
    }
    
}

extension YHOtherResidenceFillView {
    func setupUI() {
        
        //1.国家
        let view = nationView
        view.updateKeyName(name: "国家", keyValue: "")
        view.type = 1
        addSubview(view)
        view.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
        }
        
        let tap1 = UITapGestureRecognizer(target: self, action: #selector(tapCountry))
        view.addGestureRecognizer(tap1)
        
        
        //2.开始时间
        let view2 = startView
        view2.type = 1
        view2.updateKeyName(name: "开始时间", keyValue: "")
        addSubview(view2)
        view2.snp.makeConstraints { make in
            make.top.equalTo(view.snp.bottom)
            make.left.right.equalToSuperview()
//            make.height.equalTo(YHOtherSelecteItemView.getViewHBy(type: 1))
        }
        let tap2 = UITapGestureRecognizer(target: self, action: #selector(tapStartDate))
        view2.addGestureRecognizer(tap2)
        
        //3.结束时间
        let view3 = endView
        view3.type = 1
        view3.updateKeyName(name: "结束时间", keyValue: "")
        addSubview(view3)
        view3.snp.makeConstraints { make in
            make.top.equalTo(view2.snp.bottom)
            make.left.right.equalToSuperview()
//            make.height.equalTo(YHOtherSelecteItemView.getViewHBy(type: 1))
            
            make.bottom.equalToSuperview()
        }
        
        let tap3 = UITapGestureRecognizer(target: self, action: #selector(tapEndDate))
        view3.addGestureRecognizer(tap3)
    }
    
    
    func updateUI() {
        guard let dataModel = dataModel else { return }
        
        
        nationView.updateKeyName(name: "国家", keyValue: dataModel.country)
        nationView.needCheckFlag = dataModel.needCheckFlag
        
        startView.updateKeyName(name: "开始时间", keyValue: dataModel.start_time)
        startView.needCheckFlag = dataModel.needCheckFlag
        
        
        if dataModel.end_time == "至今" || dataModel.end_time == "8888-01-01" {
            endView.longTimeButton.isSelected = true
            endView.textField.placeholder = ""
            endView.updateKeyName(name: "结束时间", keyValue: "")
        } else {
            endView.longTimeButton.isSelected = false
            endView.textField.placeholder = "请选择"
            endView.updateKeyName(name: "结束时间", keyValue: dataModel.end_time)
        }
        endView.needCheckFlag = dataModel.needCheckFlag
        
        layoutIfNeeded()
    }
    
}

extension YHOtherResidenceFillView {
    @objc func tapCountry(_ gestureRecognizer: UIPanGestureRecognizer) {
        let vc = YHSelectCountryViewController()
         vc.backLocationStringController = { country in
             printLog(country)
             self.nationView.updateKeyName(name: "国家", keyValue: country)
             self.dataModel?.country = country
             
             self.layoutIfNeeded()
         }
        UIViewController.current?.navigationController?.pushViewController(vc)
    }
    
    
    @objc func tapStartDate(_ gestureRecognizer: UIPanGestureRecognizer) {
        YHDatePickView.show(type: .yyyymm,title: "请选择开始时间", lastIsTaday: true, currentDay: self.dataModel?.start_time ?? "") { date in
           printLog(date)
            
            self.startView.updateKeyName(name: "开始时间", keyValue: date)
            self.dataModel?.start_time = date
            self.layoutIfNeeded()
        }
    }
    
    @objc func tapEndDate(_ gestureRecognizer: UIPanGestureRecognizer) {
        
        if !endView.longTimeButton.isSelected {
            YHDatePickView.show(type: .yyyymm, title: "请选择结束时间", currentDay: self.dataModel?.end_time ?? "") { date in
               printLog(date)
                self.endView.updateKeyName(name: "结束时间", keyValue: date)
                self.dataModel?.end_time = date
                self.layoutIfNeeded()
            }
        }
    }
}
