//
//  YHPreviewInfoCommonCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/30.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPreviewInfoCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHPreviewInfoCell"
    
    var model : YHPreviewInfoSessionModel? {
        didSet{
            updateUI()
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
        
        // Configure the view for the selected state
    }
    
    
    private lazy var holdView : YHPreviewInfoHoldView = {
        let contryInfoView = YHPreviewInfoHoldView()
        return contryInfoView
    }()
}

extension YHPreviewInfoCell {
    func updateUI() {
        
        contentView.removeSubviews()
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        holdView.removeSubviews()
        contentView.addSubview(holdView)
        
        holdView.snp.makeConstraints { make in
            make.top.equalTo(14)
            make.left.equalToSuperview()
            make.bottom.equalToSuperview()
            make.width.equalTo(contentView.snp.width)
        }

        
        if model?.cellType == .countryInfoType {
            guard let model = model else { return }
            let view = YHPreviewInfoNameAndSubNameItemsView(frame: .zero)
            view.dataModel = model
            holdView.addSubview(view)
            view.snp.makeConstraints { make in
                make.edges.equalTo(0)
            }
        }
        else if model?.cellType == .idCardInfoType {
            guard let model = model else { return }
            let view = YHPreviewInfoCertificateInformationItemsView(frame: .zero)
            view.dataModel = model
            holdView.addSubview(view)
            view.snp.makeConstraints { make in
                make.edges.equalTo(0)
            }
        }
        else if model?.cellType == .idPictureType {
            guard let model = model else { return }
            let view = YHPreviewInfoCertificatePictureItemsView(frame: .zero)
            view.dataModel = model
            holdView.addSubview(view)
            view.snp.makeConstraints { make in
                make.edges.equalTo(0)
            }
        }
        else if model?.cellType == .questionAndAnswer {
            guard let model = model else { return }
            let view = YHPreviewInfoQuestionAndAnswerItemsView(frame: .zero)
            view.dataModel = model
            holdView.addSubview(view)
            view.snp.makeConstraints { make in
                make.edges.equalTo(0)
            }
        }
        else if model?.cellType == .workExp {
            //工作经验 - 独立处理
            guard let model = model else { return }
            let view = YHPreviewInfoWorkExpView(frame: .zero)
            view.dataModel = model
            holdView.addSubview(view)
            view.snp.makeConstraints { make in
                make.edges.equalTo(0)
            }
        }
        else {
            
        }
    }
}
