//
//  YHPreviewInfoWorkExpView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPreviewInfoWorkExpView: UIView {
    var dataModel : YHPreviewInfoSessionModel? {
        didSet {
            updateUI()
        }
    }
}

private extension  YHPreviewInfoWorkExpView {
    func updateUI() {
        guard let model = dataModel,let mmodel = model.cellData4,mmodel.isEmpty == false else { return }
        if model.cellType == .workExp {
            removeSubviews()
            //1.title
            let sessionView = YHPreviewInfoSingleLineTitleView()
            sessionView.updateTitle(title: model.cellTitle)
            addSubview(sessionView)
            sessionView.snp.makeConstraints { make in
                make.top.equalToSuperview()
                make.right.equalToSuperview().offset(-18)
                make.left.equalToSuperview().offset(18)
                make.height.equalTo(YHPreviewInfoSingleLineTitleView.viewH)
            }
            
            var lastTagView : UIView = sessionView
            for(index,items) in mmodel.enumerated() {
                if index == 0 {
                    let item: YHPreviewInfoSessionModel = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "", cellData0:items.data as? [YHPreviewQuestionAndAnswerModel])
                    let view = YHPreviewInfoNameAndSubNameItemsView(frame: .zero)
                    view.dataModel = item
                    addSubview(view)
                    view.snp.makeConstraints { make in
                        make.top.equalTo(lastTagView.snp.bottom)
                        make.left.right.equalToSuperview()
                    }
                    lastTagView = view
                } else if index == 1 {
                    let item: YHPreviewInfoSessionModel = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "", cellData0:items.data as? [YHPreviewQuestionAndAnswerModel])
                    let view = YHPreviewInfoQuestionAndAnswerItemsView(frame: .zero)
                    view.dataModel = item
                    addSubview(view)
                    view.snp.makeConstraints { make in
                        make.top.equalTo(lastTagView.snp.bottom)
                        make.left.right.equalToSuperview()
                    }
                    lastTagView = view
                } else if index == 2 {
                    //项目经验
                    let arrrr = items.data as? [YHWorkExpDataModel] ?? []
                    for (iiidex,item) in arrrr.enumerated() {
                        let view : YHPreviewInfoProjectItemView = YHPreviewInfoProjectItemView(frame: .zero)
                        view.dataModel = item
                        addSubview(view)
                        if iiidex == 0 {
                            view.snp.makeConstraints { make in
                                make.top.equalTo(lastTagView.snp.bottom)
                                make.left.right.equalToSuperview()
                            }
                        } else {
                            view.snp.makeConstraints { make in
                                make.top.equalTo(lastTagView.snp.bottom).offset(18)
                                make.left.right.equalToSuperview()
                            }
                        }
                        
                        lastTagView = view
                    }
                } else if index == 3 {
                    //简历/工作总结
                    let arrrr = items.data as? [YHWorkExpDataModel] ?? []
                    if arrrr.isEmpty == false {
                        let view : YHPreviewInfoWorkSummaryView = YHPreviewInfoWorkSummaryView(frame: .zero)
                        view.dataModel = arrrr[0]
                        addSubview(view)
                        view.snp.makeConstraints { make in
                            make.top.equalTo(lastTagView.snp.bottom).offset(18)
                            make.left.equalToSuperview().offset(kMargin)
                            make.right.equalToSuperview().offset(-kMargin)
                        }
                        lastTagView = view
                    }
                    
                } else {
                    printLog("error: 不应该出现")
                }
            }
            
            let tagView : UIView = UIView()
            tagView.backgroundColor = .clear
            addSubview(tagView)
            tagView.snp.makeConstraints { make in
                make.top.equalTo(lastTagView.snp.bottom).offset(6)
                make.left.right.equalToSuperview()
                make.height.equalTo(0.5)
                make.bottom.equalToSuperview()
            }
        } else {
            printLog("当前 view 不支持 .workExp的类型")
        }
    }
}
