//
//  YHWorkExperienceListTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/2/6.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkExperienceListTableViewCell: UITableViewCell {
    typealias ExperienceListBlock = (_ model: YHWorkItemListModel) -> ()
    typealias IsMoreBlock = (_ isMore: Bool) -> ()
    typealias NewWorkBlock = () -> ()
    var clickBlock: ExperienceListBlock?
    var deleteBlock: ExperienceListBlock?
    var isMoreBlock: IsMoreBlock?
    var newWorkBlock: NewWorkBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var cannalButton: UIButton!
    var moreButton: UIButton!
    var mainItemView: UIView!
    var bottomView: YHWorkItemAddView!
    var showPrompt: Bool = false
    var dataSource: [YHWorkItemListModel]?{
        didSet {
            updateAllViews()
        }
    }
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(14)
            make.bottom.equalTo(-7)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.text = "主申请人工作经历"
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.top.equalTo(23)
            make.height.equalTo(24)
            make.right.equalTo(-20)
        }
        
        subTitleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.text = "(从最近一份全职工作开始，直至毕业后的第一份工作）"
            label.textColor = UIColor.labelTextColor2
            return label
        }()
        centerView.addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.top.equalTo(50)
            make.height.equalTo(20)
            make.right.equalTo(-20)
        }
        
        cannalButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
            button.contentHorizontalAlignment = .center
            button.setTitle("取消操作", for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.addTarget(self, action: #selector(cannal), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        centerView.addSubview(cannalButton)
        cannalButton.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.top.equalTo(24)
            make.height.equalTo(20)
            make.width.equalTo(60)
        }
        
        moreButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "work_more"), for: .normal)
            button.addTarget(self, action: #selector(more), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(moreButton)
        moreButton.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.top.equalTo(24)
            make.height.equalTo(24)
            make.width.equalTo(24)
        }
        
        
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalTo(-65)
            make.top.equalTo(85)
        }
        
        bottomView = {
            let view = YHWorkItemAddView()
            view.addBtn.setTitle("新增工作经验".local, for: .normal)
            view.clickBlock = {[weak self] in
                guard let self = self else { return }
                if let block = self.newWorkBlock {
                    block()
                }
            }
            return view
        }()
        centerView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.right.bottom.equalTo(-18)
            make.left.equalTo(18)
            make.height.equalTo(45)
        }
    }
    
    func updateAllViews() {
        mainItemView.removeSubviews()
        guard let dataSource = dataSource else {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            mainItemView.addSubview(line)
            line.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalToSuperview()
                make.height.equalTo(1)
                make.right.equalTo(-18)
            }
            let itemView = YHWorkItemView()
            itemView.dataSource = YHWorkItemListModel()
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(1)
                make.height.equalTo(51)
                make.right.equalTo(-18)
            }
            return
        }
        
        for i in 0 ..< dataSource.count {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            mainItemView.addSubview(line)
            line.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(76 * i)
                make.height.equalTo(1)
                make.right.equalTo(-18)
            }
            let itemView = YHWorkItemView()
            itemView.clickBlock = {[weak self] model in
                guard let self = self else { return }
                if let block = self.clickBlock {
                    block(model)
                }
            }
            
            itemView.deleteBlock = {[weak self] model in
                guard let self = self else { return }
                if let block = self.deleteBlock {
                    block(model)
                }
            }
            itemView.tag = 4000 + i
            itemView.dataSource = dataSource[i]
            itemView.showPrompt = showPrompt
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(76 * i + 1)
                make.height.equalTo(75)
                make.right.equalTo(-18)
            }
        }
    }
    
    @objc func cannal() {
        moreButton.isHidden = false
        cannalButton.isHidden = true
        for i in 0..<(dataSource?.count ?? 0) {
            let view = mainItemView.viewWithTag(4000 + i) as! YHWorkItemView
            view.isShowDelete(i, isShow: false)
        }
        if let block = isMoreBlock {
            block(false)
        }
    }
    
    @objc func more() {
        moreButton.isHidden = true
        cannalButton.isHidden = false
        for i in 0..<(dataSource?.count ?? 0) {
            let view = mainItemView.viewWithTag(4000 + i) as! YHWorkItemView
            view.isShowDelete(i, isShow: true)
        }
        if let block = isMoreBlock {
            block(true)
        }
    }
}
