//
//  YHWorkExperienceTextItemView.swift
//  galaxy
//
//  Created by EDY on 2024/2/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkExperienceTextItemView: UIView {

    typealias ItemBlock = (_ model: YHWorkExperienceModel) -> ()
    var block: ItemBlock?
    var titleLabel: UILabel!
    var messageTextField: UITextView!
    var promptsLabel: UILabel!
    var nextStepImageView: UIButton!
    
    var dataSource: YHWorkExperienceModel? {
        didSet {
            updateAllViews()
        }
    }
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        titleLabel = {
            let label = UILabel()
            label.numberOfLines = 0
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.top.equalTo(16)
            make.height.equalTo(20)
        }
        
        messageTextField = {
            let textField = UITextView()
            textField.backgroundColor = UIColor.contentBkgColor
            textField.layer.cornerRadius = 4
            textField.delegate = self
            textField.font = UIFont.PFSC_R(ofSize: 14)
            return textField
        }()
        addSubview(messageTextField)
        messageTextField.snp.makeConstraints { make in
            make.right.left.equalToSuperview()
            make.top.equalTo(52)
            make.bottom.equalTo(-16)
        }
        
        promptsLabel = {
            let textField = UILabel()
            textField.font = UIFont.PFSC_R(ofSize: 14)
            textField.textColor = UIColor.labelTextColor
            return textField
        }()
        addSubview(promptsLabel)
        promptsLabel.snp.makeConstraints { make in
            make.right.left.equalTo(12)
            make.top.equalTo(64)
            make.height.equalTo(20)
        }
        
        nextStepImageView = {
            let imageView = UIButton(type: .custom)
            imageView.setBackgroundImage(UIImage(named: "work_experience_alert"), for: .normal)
            imageView.addTarget(self, action: #selector(showPrompts), for: .touchUpInside)
            return imageView
        }()
        addSubview(nextStepImageView)
        nextStepImageView.snp.makeConstraints { make in
            make.left.equalTo(titleLabel.snp.right)
            make.centerY.equalTo(titleLabel.snp.centerY)
            make.height.width.equalTo(16)
        }
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        if dataSource.isNeed ?? false {
            let str = "*" + (dataSource.title ?? "")
            let attributes: [NSAttributedString.Key: Any] = [
                .font: UIFont.PFSC_R(ofSize: 14),
                .foregroundColor: UIColor.mainTextColor
            ]
            let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
            let starRange = NSRange(location: 0, length: 1)
            questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
            titleLabel.attributedText = questionAttrStr
        } else {
            let str = dataSource.title ?? ""
            let attributes: [NSAttributedString.Key: Any] = [
                .font: UIFont.PFSC_R(ofSize: 14),
                .foregroundColor: UIColor.mainTextColor
            ]
            let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
            titleLabel.attributedText = questionAttrStr
        }
        promptsLabel.text = dataSource.prompts
        messageTextField.text = dataSource.message
        if dataSource.message?.count != 0 {
            promptsLabel.isHidden = true
        } else {
            promptsLabel.isHidden = false
        }
        
        if dataSource.id == .id18 {
            nextStepImageView.isHidden = true
        }
    }
    
    @objc func showPrompts() {
        if dataSource?.id == .id3 {
            YHWholeScreenTipsView.show(type: .company, targetView: nextStepImageView)
            
        } else if dataSource?.id == .id4 {
            YHWholeScreenTipsView.show(type: .officialWebsite, targetView: nextStepImageView)
        }
        
    }
}

extension YHWorkExperienceTextItemView: UITextViewDelegate {
    func textViewDidChange(_ textView: UITextView) {
        dataSource?.message = textView.text
        if let block = block {
            block(dataSource ?? YHWorkExperienceModel())
        }
        if textView.text.count != 0 {
            promptsLabel.isHidden = true
        } else {
            promptsLabel.isHidden = false
        }
    }
}
