//
//  YHWorkFileSyncTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkFileSyncTableViewCell: UITableViewCell {

    typealias ExperienceListBlock = (_ model: YHWorkExperienceFileModel, _ type: YHWorkFileClickType) -> ()
    typealias AddIntroductionBlock = () -> ()
    var experienceListBlock: ExperienceListBlock?
    var addIntroductionBlock: AddIntroductionBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var mainItemView: UIView!
    var bottomView: YHWorkItemAddView!
    var dataSource: [YHWorkExperienceFileModel]?{
        didSet {
            updateAllViews()
        }
    }
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-7)
        }
        
        titleLabel = {
            let label = UILabel()
            let str = "*" + "上传文件"
            let attributes: [NSAttributedString.Key: Any] = [
                .font: UIFont.PFSC_R(ofSize: 17),
                .foregroundColor: UIColor.mainTextColor
            ]
            let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
            let starRange = NSRange(location: 0, length: 1)
            questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
            label.attributedText = questionAttrStr
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
            make.right.equalTo(-18)
        }
        
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalTo(-65)
            make.top.equalTo(52)
        }
        
        bottomView = {
            let view = YHWorkItemAddView()
            view.addBtn.setTitle("上传".local, for: .normal)
            view.clickBlock = {[weak self] in
                guard let self = self else { return }
                if let block = self.addIntroductionBlock {
                    block()
                }
            }
            return view
        }()
        centerView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.right.bottom.equalTo(-18)
            make.left.equalTo(18)
            make.height.equalTo(45)
        }
    }
    
    func updateAllViews() {
        mainItemView.removeSubviews()
        for i in 0 ..< (dataSource?.count ?? 0) {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            mainItemView.addSubview(line)
            line.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(52 * i)
                make.height.equalTo(1)
                make.right.equalTo(-18)
            }
            let itemView = YHWorkFileItemView()
            itemView.dataSource = dataSource?[i]
            itemView.block = {[weak self] model, type in
                guard let self = self else { return }
                if let block = self.experienceListBlock {
                    block(model, type)
                }
            }
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(52 * i + 1)
                make.height.equalTo(51)
                make.right.equalTo(-18)
            }
        }
    }
    
    @objc func cannal() {
        
    }
    
    @objc func more() {
        
    }
}
