//
//  YHWorkHighlightsTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkHighlightsTableViewCell: UITableViewCell {
    typealias ExampleBlock = () -> ()
    typealias MessageBlock = (_ message: String) -> ()
    typealias SwitchBlock = (_ isOn: Bool) -> ()
    var exampleBlock: ExampleBlock?
    var photoBlock: ExampleBlock?
    var messageBlock: MessageBlock?
    var switchBlock: SwitchBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var lineView: UIView!
    var messageTextField: UITextView!
    var promptsLabel: UILabel!
    var detailLabel: UILabel!
    var detailSwitch: UISwitch!
    var bottomView: YHWorkActionView!
    var dataSource: String?{
        didSet {
            updateAllViews()
        }
    }
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(7)
        }
        
        titleLabel = {
            let label = UILabel()
            let str = "*" + "工作亮点"
            let attributes: [NSAttributedString.Key: Any] = [
                .font: UIFont.PFSC_R(ofSize: 17),
                .foregroundColor: UIColor.mainTextColor
            ]
            let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
            let starRange = NSRange(location: 0, length: 1)
            questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
            label.attributedText = questionAttrStr
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
            make.right.equalTo(-18)
        }
        
        subTitleLabel = {
            let label = UILabel()
            label.text = "温馨提示：如下模板仅供思路参考，工作内容请按您的实际填写，后期文案会基于该内容进行文书材料撰写，望悉知"
            label.textColor = UIColor.brandMainColor
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.numberOfLines = 0
            return label
        }()
        centerView.addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(52)
            make.height.equalTo(40)
            make.right.equalTo(-18)
        }
        
        lineView = {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            return line
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(110)
            make.height.equalTo(1)
            make.right.equalTo(-18)
        }
        
        messageTextField = {
            let textField = UITextView()
            textField.font = UIFont.PFSC_R(ofSize: 14)
            textField.delegate = self
            return textField
        }()
        centerView.addSubview(messageTextField)
        messageTextField.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(111)
            make.bottom.equalTo(-92)
        }
    
        promptsLabel = {
            let prompts = UILabel()
            prompts.font = UIFont.PFSC_R(ofSize: 14)
            prompts.textColor = UIColor(hex: 0xc0c0c0)
            prompts.text = "示例：打破常规，超越同行或其他同事的优秀业绩；或有开创性且突破公司期望的杰出贡献，且给公司带来价值和收益。\n\n请举例2-3个工作亮点：\n\na. 是什么：某项目背景或工作目标或难点\nb.为什么：为什么出现这个项目工作/难点，旨在体现分析过程，为您后面提出解决方案做铺垫\nc.怎么处理：您是怎么把这件事做好的？用了什么技术/方法？有何突出/创新之处？\nd.有什么价值：为公司、客户或您本身带来了哪些价值？客户或您本身带来了哪些价值？\n最好用实际数据证明，比如销售业绩增加了多少，或者利润增加了多少，客户群体增加了多少等。"
            prompts.numberOfLines = 0
            return prompts
        }()
        centerView.addSubview(promptsLabel)
        promptsLabel.snp.makeConstraints { make in
            make.left.equalTo(22)
            make.right.equalTo(-22)
            make.top.equalTo(116)
        }
        
        detailLabel = {
            let label = UILabel()
            label.text = "项目详细介绍"
            label.textColor = UIColor.mainTextColor
            label.font = UIFont.PFSC_R(ofSize: 14)
            return label
        }()
        centerView.addSubview(detailLabel)
        detailLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.bottom.equalTo(-62)
            make.height.equalTo(20)
            make.width.equalTo(100)
        }
        
        detailSwitch = {
            let switchView = UISwitch()
            switchView.onTintColor =  UIColor.brandMainColor
            switchView.addTarget(self, action: #selector(switchViewChange), for: .valueChanged)
            return switchView
        }()
        centerView.addSubview(detailSwitch)
        detailSwitch.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.centerY.equalTo(detailLabel.snp.centerY)
            make.height.equalTo(24)
            make.width.equalTo(45)
        }
        
        bottomView = {
            let view = YHWorkActionView()
            view.exampleBlock = {[weak self] in
                guard let self = self else { return }
                if let block = self.exampleBlock {
                    block()
                }
            }
            view.photoBlock = {[weak self] in
                guard let self = self else { return }
                if let block = self.photoBlock {
                    block()
                }
            }
            return view
        }()
        centerView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(44)
        }
        detailSwitch.transform = CGAffineTransform(scaleX: 0.77, y: 0.77)

    }
    
    func updateAllViews() {
        messageTextField.text = dataSource
        if dataSource?.count != 0 {
            promptsLabel.isHidden = true
        } else {
            promptsLabel.isHidden = false
        }
    }
    
    @objc func switchViewChange() {
        if let block = switchBlock {
            block(detailSwitch.isOn)
        }
    }
    
    func setSwitchState(_ isOn: Int) {
        if isOn == 1 {
            detailSwitch.isOn = true
        } else {
            detailSwitch.isOn = false
        }
    }
}

extension YHWorkHighlightsTableViewCell: UITextViewDelegate {
    func textViewDidChange(_ textView: UITextView) {
        if textView.text.count != 0 {
            promptsLabel.isHidden = true
        } else {
            promptsLabel.isHidden = false
        }
        if let block = messageBlock {
            block(textView.text ?? "")
        }
    }
    func textView(_ textView: UITextView, shouldChangeTextIn range: NSRange, replacementText text: String) -> Bool {
        let newLength = (textView.text as NSString).length + text.count - range.length
        
        return newLength <= 2000
    }
}
