//
//  YHWorkIntroductionViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/2/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import Alamofire

class YHWorkIntroductionViewModel: YHBaseViewModel {
    var introducetionExampleModels: [YHWorkExampleModel]?

    override init() {
        super.init()
    }
    
    func requestIntroducetionExample(callBackBlock:@escaping (_ success: Bool?, _ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.projectExample
        let _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                guard let result = [YHWorkExampleModel].deserialize(from: dic as? [Any]) else {
                    callBackBlock(false,nil)
                    return
                }
                self.introducetionExampleModels = result as? [YHWorkExampleModel]
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    // 0保存 1下一步
    func saveWorkProjectDetail(_ workModel: YHWorkExperienceDetailModel, projectModel: YHWorkExperienceProjectModel, callBackBlock:@escaping (_ success: Bool, _ error:YHErrorModel?)->()) {
        let params: [String : Any] = ["id": projectModel.id ?? 0,
                                      "order_id": workModel.order_id,
                                      "work_id": workModel.id,
                                      "project_name": projectModel.project_name ?? "",
                                      "project_start_time": projectModel.project_start_time ?? "",
                                      "project_end_time": projectModel.project_end_time ?? "",
                                      "project_highlights": projectModel.project_highlights ?? 0,
                                      "create_from_appid": projectModel.create_from_appid ?? 2,
                                      "update_from_appid": projectModel.create_from_appid ?? 2
                                    ]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.saveProject
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            guard let self = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestFileMessage(_ url: String, callBackBlock:@escaping (_ success: Bool, _ model: YHFileContent?,_ error:YHErrorModel?)->()) {
//        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.ocrFileContent + "?file_url=\(url)"
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.ocrFileContent
        let param: [String: Any] = ["file_url": url]
        let _ = YHNetRequest.getRequest(url: strUrl,params:param) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                guard let result = YHFileContent.deserialize(from: dic as? Dictionary) else {
                    callBackBlock(false, nil, nil)
                    return
                }
                callBackBlock(true, result, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, nil,error)
            }
        } failBlock: { err in
            callBackBlock(false, nil, err)
        }
    }
}

