//
//  YHLoginTipsView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHLoginTipsView: UIView {
    public var clickLoginBtnCallBackBlock : (()->())?
    public var viewType : Int  = 0 { // 0 - 有登录按钮   1- 无登录按钮,仅数据提示
        didSet {
            if viewType == 0 {
                iconImgV.image = UIImage(named: "login_tip_icon")
                tipsLab.text = "登录后可以查看"
                loginBtn.isHidden = false
            } else if viewType == 1 {
                iconImgV.image = UIImage(named: "service_center_no_data")
                tipsLab.text = "更多内容敬请期待"
                loginBtn.isHidden = true
            } else {
                
                iconImgV.image = UIImage(named: "login_tip_icon")
                tipsLab.text = "登录后可以查看"
                loginBtn.isHidden = false
            }
            
        }
    }
    
    private lazy var iconImgV : UIImageView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "login_tip_icon")
        imagV.contentMode = .scaleAspectFill
        return imagV
    }()
    
    private lazy var tipsLab : UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.labelTextColor2
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.textAlignment = .center
        lable.text = "登录后可以查看"
        return lable
    }()
    
    private lazy var loginBtn : UIButton = {
        let btn = UIButton(type: .custom)
        btn.setTitle("去登录", for: .normal)
        btn.layer.cornerRadius = kCornerRadius3
        btn.clipsToBounds = true
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 12)
        btn.setTitleColor(.white, for: .normal)
        return btn
    }()
    
    public override init(frame: CGRect) {
        super.init(frame:frame)
        initView()
    }
    
    
    override func layoutSubviews() {
        super.layoutSubviews()
        
        tipsLab.snp.removeConstraints()
        loginBtn.snp.removeConstraints()
        loginBtn.isHidden = true
        if viewType == 0 {
            loginBtn.isHidden = false
            tipsLab.snp.remakeConstraints { make in
                make.top.equalTo(iconImgV.snp.bottom).offset(12)
                make.centerX.equalToSuperview()
                make.left.right.equalToSuperview()
            }
            
            loginBtn.snp.remakeConstraints { make in
                make.top.equalTo(tipsLab.snp.bottom).offset(21)
                make.centerX.equalToSuperview()
                make.height.equalTo(36)
                make.width.equalTo(86)
                make.bottom.equalToSuperview()
            }
        } else {
            tipsLab.snp.remakeConstraints { make in
                make.top.equalTo(iconImgV.snp.bottom).offset(12)
                make.centerX.equalToSuperview()
                make.left.right.equalToSuperview()
                make.bottom.equalToSuperview()
            }
        }
    }
    
    private func initView() {
        addSubview(iconImgV)
        iconImgV.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.centerX.equalToSuperview()
            make.height.equalTo(93)
            make.width.equalTo(93)
        }
        
        addSubview(tipsLab)
        tipsLab.snp.makeConstraints { make in
            make.top.equalTo(iconImgV.snp.bottom).offset(12)
            make.centerX.equalToSuperview()
            make.left.right.equalToSuperview()
        }
        
        addSubview(loginBtn)
        loginBtn.snp.makeConstraints { make in
            make.top.equalTo(tipsLab.snp.bottom).offset(21)
            make.centerX.equalToSuperview()
            make.height.equalTo(36)
            make.width.equalTo(86)
            make.bottom.equalToSuperview()
        }
        
        loginBtn.addTarget(self, action: #selector(clickLoginBtn), for: .touchUpInside)
        layoutIfNeeded()
        loginBtn.backgroundColor = .brandMainColor
        loginBtn.addYinHeGradualLayer()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func clickLoginBtn() {
        self.clickLoginBtnCallBackBlock?()
    }
}
