//
//  YHProgressView.swift
//  galaxy
//
//  Created by EDY on 2024/4/17.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHProgressView: UIView {
     private let progressLayer = CAShapeLayer()
     
     override init(frame: CGRect) {
         super.init(frame: frame)
         configure()
     }
     
     required init?(coder: NSCoder) {
         super.init(coder: coder)
         configure()
     }
     
    func changeColor(_ color: UIColor) {
        progressLayer.strokeColor = color.cgColor // 设置进度条颜色
    }
    
     private func configure() {
         // 创建底部圆形路径
         let center = CGPoint(x: bounds.midX, y: bounds.midY)
         let lineWidth: CGFloat = 3 // 圆环路径宽度
         let radius = (min(bounds.width, bounds.height) - lineWidth) / 2 // 圆的半径
         let startAngle = -CGFloat.pi / 2 // 起始角度
         let endAngle = 1.5 * CGFloat.pi // 终点角度
         
         // 创建进度条圆形路径
         let progressPath = UIBezierPath(arcCenter: center,
                                         radius: radius,
                                         startAngle: startAngle,
                                         endAngle: endAngle,
                                         clockwise: true)
         
         // 配置进度条CAShapeLayer
         progressLayer.path = progressPath.cgPath
         progressLayer.strokeColor = UIColor(hex: 0x00BF60).cgColor // 进度条颜色
         progressLayer.fillColor = UIColor.clear.cgColor
         progressLayer.lineWidth = lineWidth // 进度条宽度
         progressLayer.lineCap = .square
         
         // 设置初始进度
         progressLayer.strokeEnd = 0
         
         layer.addSublayer(progressLayer)
     }
     
     func setProgress(_ progress: Float, animated: Bool) {
         let animation = CABasicAnimation(keyPath: "strokeEnd")
         animation.fromValue = progressLayer.strokeEnd
         animation.toValue = progress
         animation.duration = animated ? 1.0 : 0
         progressLayer.strokeEnd = CGFloat(progress)
         progressLayer.add(animation, forKey: "progressAnimation")
     }
 }
