//
//  YHServiceBannerView.swift
//  galaxy
//
//  Created by EDY on 2024/4/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import FSPagerView

class YHServiceBannerView: UIView {
    
    // 位置、大小、图片、文本
    var dataArr: [YHBannerModel] = [] {
        didSet {
            self.indicatorView.indicatorItems = self.dataArr.count
            bannerView.reloadData()
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
   
    
    private lazy var bannerView: FSPagerView = {
        let view = FSPagerView()
        view.delegate = self
        view.dataSource = self
        view.automaticSlidingInterval = 3
        view.register(FSPagerViewCell.self, forCellWithReuseIdentifier: "cell")
        view.itemSize = FSPagerView.automaticSize
//        view.interitemSpacing = 10
        return view
    }()
    
    lazy var pageControl: FSPageControl = {
        let view = FSPageControl()
        return view
    }()
    
    lazy var indicatorView : YHHomeBannerIndicatorView = {
        let view = YHHomeBannerIndicatorView()
        return view
    }()
}

private extension YHServiceBannerView {
    func initView() {
        addSubview(bannerView)
        bannerView.snp.makeConstraints { make in
            make.top.left.right.bottom.equalToSuperview()
        }
        
        bannerView.addSubview(pageControl)
        pageControl.snp.makeConstraints { make in
            make.left.bottom.right.equalToSuperview()
            make.height.equalTo(25)
        }
//        setupPageControl()
        bannerView.addSubview(indicatorView)
        indicatorView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.height.equalTo(2)
            make.bottom.equalTo(-14)
        }
        bannerView.reloadData()
    }
    
    func setupPageControl() {
        self.pageControl.numberOfPages = self.dataArr.count
        self.pageControl.contentHorizontalAlignment = .center
        self.pageControl.contentInsets = UIEdgeInsets(top: 0, left: 12, bottom: 10, right: 12)
        
        
        let normalImage = UIImage(color: UIColor(hex: 0xff0000, alpha: 1.0), size: CGSize(width: 5, height: 5))
        let selectImage = UIImage(color: .white, size: CGSize(width: 8, height: 5))
        self.pageControl.setImage(normalImage, for: .normal)
        self.pageControl.setImage(selectImage, for: .selected)
        
        self.pageControl.interitemSpacing = 3
    }
    
    func goAppTab(tabBarName : String) {
        if !tabBarName.isEmpty {
            if tabBarName.contains("tabBarHome",caseSensitive: false) {
                //首页
                goTabBarBy(tabType: .home)
            } else if tabBarName.contains("tabBarService",caseSensitive: false) {
                //服务中心
                goTabBarBy(tabType: .service)
            } else if tabBarName.contains("tabBarMsg",caseSensitive: false) {
                //消息
                goTabBarBy(tabType: .message)
            } else if tabBarName.contains("tabBarMine",caseSensitive: false) {
                //我的
                goTabBarBy(tabType: .mine)
                
            } else {
                
            }
        }
    }
}

extension YHServiceBannerView: FSPagerViewDataSource, FSPagerViewDelegate {
    
    public func numberOfItems(in pagerView: FSPagerView) -> Int {
        return self.dataArr.count
    }
    
    public func pagerView(_ pagerView: FSPagerView, cellForItemAt index: Int) -> FSPagerViewCell {
        let cell = pagerView.dequeueReusableCell(withReuseIdentifier: "cell", at: index)
        if index < dataArr.count {
            let model = dataArr[index]
            if model.id != 0 {
                if let url = URL(string: model.img_url) {
//                    cell.imageView?.kf.setImage(with: url)
                    cell.imageView?.kf.setImage(with: url, placeholder: UIImage(named: "global_default_image"))
                    
                }
            } else {
                cell.imageView?.image = UIImage(named: model.img_url)
            }
//            cell.textLabel?.text = model.name
        }
        cell.imageView?.contentMode = .scaleAspectFill
        cell.backgroundColor = .contentBkgColor
        cell.contentView.layer.shadowColor = UIColor.clear.cgColor
        
        return cell
    }
    
    // MARK: - FSPagerView Delegate
    
    func pagerView(_ pagerView: FSPagerView, didSelectItemAt index: Int) {
        pagerView.deselectItem(at: index, animated: true)
        pagerView.scrollToItem(at: index, animated: true)
        if index >= dataArr.count {
            return
        }
        let model = dataArr[index]
        
        if model.isLocalItemFlag {
            return
        }
        
        if model.skip_url.isEmpty == false {
            switch model.skip_type {
            case 1: //跳转H5
                let vc = YHHomeWebViewController()
                vc.url = model.skip_url
                self.parentViewController?.navigationController?.pushViewController(vc)
            case 2: //跳转APP内Tab
                goAppTab(tabBarName:model.skip_url)
            case 3://3-跳转资讯页
                let vc = YHHomeWebViewController()
                vc.url = model.skip_url
                self.parentViewController?.navigationController?.pushViewController(vc)
            case 0://0 不需要跳转
                printLog("0 不需要跳转")
            default:
                YHHUD.flash(message: "不需要处理的类型")
                break
            }
        } else {
            YHHUD.flash(message: "error:skip_url不能为空")
        }
    }
    
    func pagerViewWillEndDragging(_ pagerView: FSPagerView, targetIndex: Int) {
        self.indicatorView.curIndicatorIndex = targetIndex
    }
    
    func pagerViewDidEndScrollAnimation(_ pagerView: FSPagerView) {
        self.indicatorView.curIndicatorIndex = pagerView.currentIndex
    }
}
