//
//  YHServiceOrderProgressTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/4/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHServiceOrderProgressTableViewCell: UITableViewCell {
    var titleLabel: UILabel!
    var messageLabel: UILabel!
    var buttonLabel: UILabel!
    var progressImageView: UIImageView!
    var progressLabel: UILabel!
    var progress: YHProgressView!
    var dataModel : YHServiceCenterProgressModel? {
        didSet {
            updateUI()
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}

extension YHServiceOrderProgressTableViewCell {
    func updateUI() {
        guard let model = dataModel else { return }
        messageLabel.text = "您还有" + "\(model.num)" + "份信息待填写哦~"
        // 0未知 1待开始 2进行中 3 已完成
        if model.status == 1 {
            titleLabel.textColor = UIColor(hex: 0x121a26,transparency: 0.3)
            messageLabel.textColor = UIColor(hex: 0x94a3b8,transparency: 0.3)
            buttonLabel.text = "待开始"
            buttonLabel.backgroundColor = UIColor(hex: 0xb8babe,transparency: 0.3)
            progressImageView.image = UIImage(named: "service_progress_normal")
            // 1 证件 2 信息完善 3 我的评分 4 我的方案 5 我的签字 6我的文书
            if model.type == 1 {
                titleLabel.text = "我的证件"
                messageLabel.text = "您的证件还没生成哦~"
            }
            if model.type == 2 {
                titleLabel.text = "我的信息"
            }
            if model.type == 3 {
                titleLabel.text = "我的评分"
                messageLabel.text = "您的评分报告还没生成哦~"
            }
            if model.type == 4 {
                titleLabel.text = "我的方案"
                messageLabel.text = "您的专属方案还没生成哦~"
            }
            if model.type == 5 {
                titleLabel.text = "我的签字"
                messageLabel.text = "您的文件还没签字哦~"
            }
            if model.type == 6 {
                titleLabel.text = "我的文书"
                messageLabel.text = "您的文书还没确认哦~"
            }
            let b: ASAttributedString = .init(NSAttributedString(string: "\(model.percentage)"), .font(UIFont(name: "DINAlternate-Bold", size: 24)!),.foreground(UIColor(hex: 0x121a26).withAlphaComponent(0.3)))
            let bb: ASAttributedString = .init("%", .font(UIFont.PFSC_M(ofSize: 10)),.foreground(UIColor(hex: 0x121a26).withAlphaComponent(0.3)))
            progressLabel.attributed.text = b + bb
        }
        if model.status == 2 {
            titleLabel.textColor = UIColor.mainTextColor
            buttonLabel.text = "进行中"
            buttonLabel.backgroundColor = UIColor.brandMainColor
            progressImageView.image = UIImage(named: "service_progress_start")
            progress.changeColor(UIColor.brandMainColor)
            // 1 证件 2 信息完善 3 我的评分 4 我的方案 5 我的签字 6我的文书
            if model.type == 1 {
                titleLabel.text = "我的证件"
//                messageLabel.text = "恭喜您，证件已全部上传完~"
                buttonLabel.text = "去上传"
                let a: ASAttributedString = .init("您还有", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor(hex: 0x94a3b8)))
                let aa: ASAttributedString = .init(NSAttributedString(string: "\(model.num)份"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.brandMainColor))
                let aaa: ASAttributedString = .init("证件待上传哦~", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor(hex: 0x94a3b8)))
                messageLabel.attributed.text = a + aa + aaa
            }
            if model.type == 2 {
                titleLabel.text = "我的信息"
                buttonLabel.text = "去填写"
                let a: ASAttributedString = .init("您还有", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor(hex: 0x94a3b8)))
                let aa: ASAttributedString = .init(NSAttributedString(string: "\(model.num)份"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.brandMainColor))
                let aaa: ASAttributedString = .init("信息待填写哦~", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor(hex: 0x94a3b8)))
                messageLabel.attributed.text = a + aa + aaa
            }
            if model.type == 3 {
                titleLabel.text = "我的评分"
                messageLabel.text = "后端出问题会显示"
            }
            if model.type == 4 {
                titleLabel.text = "我的方案"
                messageLabel.text = "后端出问题会显示"
            }
            if model.type == 5 {
                titleLabel.text = "我的签字"
                buttonLabel.text = "去签字"
                let a: ASAttributedString = .init("您还有", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor(hex: 0x94a3b8)))
                let aa: ASAttributedString = .init(NSAttributedString(string: "\(model.num)份"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.brandMainColor))
                let aaa: ASAttributedString = .init("文件待签字哦~", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor(hex: 0x94a3b8)))
                messageLabel.attributed.text = a + aa + aaa
            }
            if model.type == 6 {
                titleLabel.text = "我的文书"
                buttonLabel.text = "去确认"
                let a: ASAttributedString = .init("您还有", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor(hex: 0x94a3b8)))
                let aa: ASAttributedString = .init(NSAttributedString(string: "\(model.num)份"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.brandMainColor))
                let aaa: ASAttributedString = .init("文书待确认哦~", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor(hex: 0x94a3b8)))
                messageLabel.attributed.text = a + aa + aaa
            }
            let b: ASAttributedString = .init(NSAttributedString(string: "\(model.percentage)"), .font(UIFont(name: "DINAlternate-Bold", size: 24)!),.foreground(UIColor(hex: 0x121a26)))
            let bb: ASAttributedString = .init("%", .font(UIFont.PFSC_M(ofSize: 10)),.foreground(UIColor(hex: 0x121a26).withAlphaComponent(0.3)))
            progressLabel.attributed.text = b + bb
        }
        if model.status == 3 {
            titleLabel.textColor = UIColor.mainTextColor
            messageLabel.textColor = UIColor(hex: 0x94a3b8)
            buttonLabel.text = "去查看"
            progress.changeColor(UIColor(hex: 0x55cba0))
            buttonLabel.backgroundColor = UIColor(hex: 0x55cba0)
            progressImageView.image = UIImage(named: "service_progress_end")
            // 1 证件 2 信息完善 3 我的评分 4 我的方案 5 我的签字 6我的文书
            if model.type == 1 {
                titleLabel.text = "我的证件"
                messageLabel.text = "恭喜您，证件已全部上传完~"
            }
            if model.type == 2 {
                titleLabel.text = "我的信息"
                messageLabel.text = "恭喜您，信息已全部填写完~"
            }
            if model.type == 3 {
                titleLabel.text = "我的评分"
                messageLabel.text = "恭喜您，评分报告已生成~"
            }
            if model.type == 4 {
                titleLabel.text = "我的方案"
                messageLabel.text = "恭喜您，专属方案已生成~"
            }
            if model.type == 5 {
                titleLabel.text = "我的签字"
                messageLabel.text = "恭喜您，文件已全部签字完~"
            }
            if model.type == 6 {
                titleLabel.text = "我的文书"
                messageLabel.text = "恭喜您，文件已全部确认完~"
            }
            let b: ASAttributedString = .init(NSAttributedString(string: "\(model.percentage)"), .font(UIFont(name: "DINAlternate-Bold", size: 24)!),.foreground(UIColor(hex: 0x121a26)))
            let bb: ASAttributedString = .init("%", .font(UIFont.PFSC_M(ofSize: 10)),.foreground(UIColor(hex: 0x121a26).withAlphaComponent(0.3)))
            progressLabel.attributed.text = b + bb
        }
        if model.percentage == 0 {
            progress.isHidden = true
        } else {
            progress.setProgress(Float(CGFloat(model.percentage))/100.0, animated: false)
            progress.isHidden = false
        }
    }
    
    func setupUI() {
        let holdView = UIView()
        holdView.backgroundColor = .white
        holdView.layer.cornerRadius = kCornerRadius6
        holdView.clipsToBounds = true
        
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        
        contentView.addSubview(holdView)
        holdView.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        holdView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(21)
            make.left.equalTo(21)
            make.height.equalTo(24)
        }
        
        messageLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 13)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        holdView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.top.equalTo(49)
            make.left.equalTo(21)
            make.height.equalTo(18)
        }
        
        buttonLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 13)
            label.textColor = .white
            label.backgroundColor = UIColor.brandMainColor
            label.layer.cornerRadius = kCornerRadius4
            label.masksToBounds = true
            label.textAlignment = .center
            return label
        }()
        holdView.addSubview(buttonLabel)
        buttonLabel.snp.makeConstraints { make in
            make.bottom.equalTo(-19)
            make.left.equalTo(21)
            make.height.equalTo(27)
            make.width.equalTo(57)
        }
        
        progressImageView = {
            let view = UIImageView()
            return view
        }()
        holdView.addSubview(progressImageView)
        progressImageView.snp.makeConstraints { make in
            make.top.equalTo(24)
            make.right.equalTo(-32)
            make.height.equalTo(80)
            make.width.equalTo(80)
        }
        
        progressLabel = {
            let label = UILabel()
            label.textAlignment = .center
//            label.font = UIFont.PFSC_M(ofSize: 13)
//            label.textColor = UIColor.mainTextColor
            return label
        }()
        holdView.addSubview(progressLabel)
        progressLabel.snp.makeConstraints { make in
            make.center.equalTo(progressImageView.snp.center)
            make.width.equalTo(60)
            make.height.equalTo(29)
        }
        
        progress = {
            let view = YHProgressView(frame: CGRect(x: 0, y: 0, width: 80, height: 80))
            return view
        }()
        holdView.addSubview(progress)
        progress.snp.makeConstraints { make in
            make.top.equalTo(24)
            make.right.equalTo(-32)
            make.height.equalTo(80)
            make.width.equalTo(80)
        }
    }
}
