//
//  YHVerificationCodeLoginController.swift
//  galaxy
//
//  Created by EDY on 2024/1/6.
//  Copyright © 2024 www.davidhuang.com. All rights reserved.
//

import UIKit

class YHVerificationCodeLoginController: YHBaseViewController {
    var bgImageView: UIImageView!
    var loginTitleLabel: UILabel!
    var loginSubTitleLabel: UILabel!
    var phoneLabel: UILabel!
    var phoneMessageView: YHPhoneMessageView!
    var getCodeButton: UIButton!
    var emailButton: UIButton!
    var centerLine: UIView!
    var centerImageView: UIImageView!
    var promptsLabel: UILabel!
    var wxButton: UIButton!
    var privacyView: YHLoginPrivacyView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setView()
        // Do any additional setup after loading the view.
        
    }
    
    func setView() {
        bgImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "login_bg_image")
            return imageView
        }()
        view.addSubview(bgImageView)
        bgImageView.snp.makeConstraints { make in
            make.left.right.top.bottom.equalTo(view)
        }
        loginTitleLabel = {
            let label = UILabel()
            label.text = "登录后更精彩"
            label.font = UIFont.PFSC_M(ofSize: 32)
            label.textColor = UIColor(hex:0xffffff)
            return label
        }()
        view.addSubview(loginTitleLabel)
        loginTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(14)
            make.right.equalTo(-14)
            make.top.equalTo(111)
            make.height.equalTo(39)
        }
        loginSubTitleLabel = {
            let label = UILabel()
            label.text = "香港美好生活期待与你的相遇"
            label.font = UIFont.PFSC_R(ofSize: 20)
            label.textColor =  UIColor(hex:0xffffff)
            return label
        }()
        view.addSubview(loginSubTitleLabel)
        loginSubTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(14)
            make.right.equalTo(-14)
            make.top.equalTo(159)
            make.height.equalTo(24)
        }
        phoneLabel = {
            let label = UILabel()
            label.text = "未注册手机验证后完成注册"
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textAlignment = .left
            label.textColor =  UIColor(hex:0xffffff)
            return label
        }()
        view.addSubview(phoneLabel)
        phoneLabel.snp.makeConstraints { make in
            make.left.equalTo(33)
            make.right.equalTo(-33)
            make.top.equalTo(242)
            make.height.equalTo(22)
        }
        
        phoneMessageView = {
            let view = YHPhoneMessageView()
            view.backgroundColor =  UIColor(hex:0xffffff)
            view.layer.cornerRadius = 24
            view.block = { [weak self] in
                guard let self = self else { return }
                let vc = YHPickPhoneAddressViewController()
                self.navigationController?.pushViewController(vc)
            }
            return view
        }()
        view.addSubview(phoneMessageView)
        phoneMessageView.snp.makeConstraints { make in
            make.left.equalTo(33)
            make.right.equalTo(-33)
            make.top.equalTo(278)
            make.height.equalTo(48)
        }
        
        getCodeButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor(hex:0xd8d8d8).withAlphaComponent(0.8)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("获取验证码", for: .normal)
            button.setTitleColor( UIColor(hex:0x979797), for: .normal)
            button.layer.cornerRadius = 24
            button.addTarget(self, action: #selector(getCode), for: .touchUpInside)
            return button
        }()
        view.addSubview(getCodeButton)
        getCodeButton.snp.makeConstraints { make in
            make.left.equalTo(33)
            make.right.equalTo(-33)
            make.top.equalTo(348)
            make.height.equalTo(48)
        }
        emailButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.setTitle("邮箱登录", for: .normal)
            button.setTitleColor( UIColor(hex:0xffffff), for: .normal)
            return button
        }()
        view.addSubview(emailButton)
        emailButton.snp.makeConstraints { make in
            make.left.equalTo(33)
            make.top.equalTo(424)
            make.height.equalTo(20)
            make.width.equalTo(68)
        }
        
        centerImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "login_center_image")
            return imageView
        }()
        view.addSubview(centerImageView)
        centerImageView.snp.makeConstraints { make in
            make.centerX.equalTo(view)
            make.width.equalTo(153)
            make.height.equalTo(108)
            make.bottom.equalTo(-188)
        }
        promptsLabel = {
            let label = UILabel()
            label.text = "其他登录方式（第三方账号注册需绑定手机号）"
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor =  UIColor(hex:0xffffff)
            label.textAlignment = .center
            return label
        }()
        view.addSubview(promptsLabel)
        promptsLabel.snp.makeConstraints { make in
            make.left.equalTo(14)
            make.right.equalTo(-14)
            make.bottom.equalTo(-89)
            make.height.equalTo(20)
        }
        wxButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "login_style_wx"), for: .normal)
            return button
        }()
        view.addSubview(wxButton)
        wxButton.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.bottom.equalTo(-59)
            make.height.equalTo(18)
            make.width.equalTo(21)
        }
        privacyView = {
            let view = YHLoginPrivacyView()
            return view
        }()
        view.addSubview(privacyView)
        privacyView.snp.makeConstraints { make in
            make.bottom.equalTo(-24)
            make.centerX.equalToSuperview()
            make.height.equalTo(20)
            make.width.equalTo(308)
        }
    }
    
    @objc func getCode() {
        let vc = YHCodeResultViewController()
        self.navigationController?.pushViewController(vc)
    }
}
