//
//  YHShareManager.swift
//  galaxy
//
//  Created by EDY on 2024/5/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHShareManager: NSObject {
    static let shared = YHShareManager()
    var scene: WXScene = WXSceneSession
}


extension YHShareManager {
    func sendTextContect(_ text: String) {
        let req = SendMessageToWXReq()
        req.bText = true
        req.text = text
        req.scene = Int32(scene.rawValue)
        WXApi.send(req) { flag in
            if !flag {
                YHHUD.flash(message: "分享失败")
            }
        }
    }
    
    func sendLinkContent(_ title: String = "", _ description: String = "", _ image: UIImage = UIImage(), link: String) {
        let message =  WXMediaMessage()
    
        message.title = title
        message.description = description
        let width = 240.0 as CGFloat
        let height = width*image.size.height/image.size.width
        UIGraphicsBeginImageContext(CGSizeMake(width, height))
        image.draw(in: CGRectMake(0, 0, width, height))
        message.setThumbImage(UIGraphicsGetImageFromCurrentImageContext() ?? UIImage())
        UIGraphicsEndImageContext()
         
        let ext =  WXWebpageObject()
        ext.webpageUrl = link
        message.mediaObject = ext
         
        let req =  SendMessageToWXReq()
        req.bText = false
        req.message = message
        req.scene = Int32(scene.rawValue)
        WXApi.send(req) { flag in
            if !flag {
                YHHUD.flash(message: "分享失败")
            }
        }
    }
    
    func sendVideoContent(_ title: String = "", _ description: String = "", _ image: UIImage = UIImage(), link: String) {
        let message =  WXMediaMessage()
    
        message.title = title
        message.description = description
        let width = 240.0 as CGFloat
        let height = width*image.size.height/image.size.width
        UIGraphicsBeginImageContext(CGSizeMake(width, height))
        image.draw(in: CGRectMake(0, 0, width, height))
        message.setThumbImage(UIGraphicsGetImageFromCurrentImageContext() ?? UIImage())
        UIGraphicsEndImageContext()
         
        let ext =  WXVideoObject()
        ext.videoUrl = link
        message.mediaObject = ext
         
        let req = SendMessageToWXReq()
        req.bText = false
        req.message = message
        req.scene = Int32(scene.rawValue)
        WXApi.send(req) { flag in
            if !flag {
                YHHUD.flash(message: "分享失败")
            }
        }
    }
    
    func sendImageContent(_ image: UIImage) {
        let message =  WXMediaMessage()
                
        //发送的图片
        let imageObject =  WXImageObject()
        imageObject.imageData = image.pngData() ?? Data()
        message.mediaObject = imageObject
       //图片缩略图
        let width = 240.0 as CGFloat
        let height = width*image.size.height/image.size.width
        UIGraphicsBeginImageContext(CGSizeMake(width, height))
        image.draw(in: CGRectMake(0, 0, width, height))
        message.setThumbImage(UIGraphicsGetImageFromCurrentImageContext() ?? UIImage())
        UIGraphicsEndImageContext()
        
        let req = SendMessageToWXReq()
        req.bText = false
        req.message = message
        req.scene = Int32(scene.rawValue)
        WXApi.send(req) { flag in
            if !flag {
                YHHUD.flash(message: "分享失败")
            }
        }
    }
}
