//
//  YHConstantArrayData.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHOtherPickerViewType: Int {
    // 按自然顺序递增
    case none = 0
    // 语言能力
    case language
    // 专业技能行业
    case professionalSkill
    // 用人单位性质
    case nature
    // 工作证明文件
    case certificate
    // 行政架构层级
    case structure
    // 职位水平类别
    case level
    // 高管证明文件
    case prove
    // 证件类别
    case idType
    // 性别
    case sex
    // 婚姻状况
    case marry
    //学位
    case degree
    //学位地址
    case degreeAddress
}


class YHConstantArrayData {
    static let arrLanguage : [[String : String]] =  [
        [
            "id":"1",
            "title": "中文及英文",
            "dec": "国外大学（英语国家）毕业，英文授课，获得学位证。（如为中外联合办学，在中国上课的，不算）",
        ],
        [
            "id": "2",
            "title": "中文及英文",
            "dec": " 有近两年的雅思或托福成绩单（雅思考试G类或A类总分达6分；托福笔试达550分，计算机达213分，网考达80分）",
        ],
        [
            "id": "4",
            "title": "中文及另一种外语",
            "dec": "非英文的外语，如：法文、日文等（需提供相关证书）",
        ],
        [
            "id": "5",
            "title": "仅中文",
            "dec": "",
        ],
        [
            "id": "6",
            "title": "仅英文",
            "dec": "",
        ],
    ]
    
    
    static let arrSkill : [[String : String]] =  [
        [
            "title": "学术研究及教育",
            "dec": "幼儿教育、高等教育、学术研究",
            "val": "",
            "value": "1",
        ],
        [
            "title": "建筑、测量、工程及建造",
            "dec": "园景设计、建筑、测量、土木/电机/机器/机构/环境工程",
            "val": "",
            "value": "2",
        ],
        [
            "title": "艺术及文化",
            "dec": "表演艺术、美术、博物馆、图书馆、摄影",
            "val": "",
            "value": "3",
        ],
        [
            "title": "广播及娱乐",
            "dec": "广播及节目制作、电影、录像及电视制作、唱片及音乐出版",
            "val": "",
            "value": "4",
        ],
        [
            "title": "业务支援及人力资源",
            "dec": "业务咨询顾问、公司秘书、行政支援、人事管理、招聘服务、公关关系服务、广告、信息服务",
            "val": "",
            "value": "5",
        ],
        [
            "title": "餐饮服务及旅游",
            "dec": "酒吧、餐厅、酒店、旅行代理",
            "val": "",
            "value": "6",
        ],
        [
            "title": "商业及贸易",
            "dec": "进出口、零售、批发",
            "val": "",
            "value": "7",
        ],
        [
            "title": "金融及会计服务",
            "dec": "会计、银行、保险、证券、投资银行",
            "val": "",
            "value": "8",
        ],
        [
            "title": "医疗保健及兽医服务",
            "dec": "西医药、中医药、牙科服务、医学科技、职业治疗、护理、兽医服务",
            "val": "",
            "value": "9",
        ],
        [
            "title": "资讯科技及电讯",
            "dec": "资讯科技顾问、固网及无线通信",
            "val": "",
            "value": "10",
        ],
        [
            "title": "法律服务",
            "dec": "法律事务",
            "val": "",
            "value": "11",
        ],
        [
            "title": "物流运输",
            "dec": "物流、空运、海运、陆运",
            "val": "",
            "value": "12",
        ],
        [
            "title": "工业制造",
            "dec": "电机、电子、食物及饮料、化工、金属、玩具、纺织、钟表、珠宝、印刷及出版",
            "val": "",
            "value": "13",
        ],
        [
            "title": "体育运动",
            "dec": "体育运动",
            "val": "",
            "value": "14",
        ],
        [
            "title": "其他",
            "example": "",
            "val": "",
            "value": "15",
            "dec": ""
        ],
    ]
    
    static let arrNature : [[String : String]] =  [
        [
            "title": "有限责任公司",
            "id": "有限责任公司"
        ],
        [
            "title": "股份有限公司",
            "id": "股份有限公司"
        ],
        [
            "title": "跨国有限责任公司",
            "id": "跨国有限责任公司"
        ],
        [
            "title": "跨国股份有限公司",
            "id": "跨国股份有限公司"
        ],
        [
            "title": "上市公司",
            "id": "上市公司"
        ],
        [
            "title": "上市跨国公司",
            "id": "上市跨国公司"
        ],
        [
            "title": "教育机构",
            "id": "教育机构"
        ],
        [
            "title": "半公营企业",
            "id": "半公营企业"
        ],
        [
            "title": "政府机构",
            "id": "政府机构"
        ],
        [
            "title": "跨国合伙企业",
            "id": "跨国合伙企业"
        ],
        [
            "title": "跨国个人独资企业",
            "id": "跨国个人独资企业"
        ],
        [
            "title": "个人独资企业",
            "id": "个人独资企业"
        ],
        [
            "title": "国家/政府间组织",
            "id": "国家/政府间组织"
        ],
        [
            "title": "志愿/慈善/宗教团体",
            "id": "志愿/慈善/宗教团体"
        ],
        [
            "title": "其他（请备注）",
            "id": "其他（请备注）"
        ]
    ]
    
    static let arrCertificate : [[String : String]] = [
        ["id": "盖章并签字的推荐信 (证明效果最强)",
         "title": "盖章并签字的推荐信 (证明效果最强)"
        ],
        ["id": "签字的推荐信+盖章的工作证明",
         "title": "签字的推荐信+盖章的工作证明"
        ],
        ["id": "仅有签字的推荐信",
         "title": "仅有签字的推荐信"
        ],
        ["id": "仅有社保记录/劳动合同/工牌等",
         "title": "仅有社保记录/劳动合同/工牌等"
        ],
        ["id": "仅提供声明书解释",
         "title": "仅提供声明书解释"
        ],
        ["id": "仅有工作证明",
         "title": "仅有工作证明"
        ]
    ]
    
    static let arrStructure : [[String : String]] = [
        ["title": "组织架构最顶级",
         "id": "1"
        ],
        ["title": "组织架构第二层级",
         "id": "2"
        ],
        ["title": "组织架构第三层级",
         "id": "3"
        ],
        ["title": "组织架构第四层级",
         "id": "4"
        ],
        ["title": "以上都不是",
         "id": "5"
        ]
    ]
    
    static let arrLevel : [[String : String]] = [
        ["title": "高级经理人",
         "id": "1"
        ],
        ["title": "中级经理人",
         "id": "2"
        ],
        ["title": "初级经理人",
         "id": "3"
        ],
        ["title": "专业人士",
         "id": "4"
        ],
        ["title": "半专业人士",
         "id": "5"
        ],
        ["title": "其他",
         "id": "6"
        ]
    ]
    
    static let arrProve : [[String : String]] = [
        ["title": "盖章且签字的组织架构图和审计报告",
         "id": "盖章且签字的组织架构图和审计报告"
        ]
    ]
    
    static let arrIdType : [[String : String]] = [
        ["title": "护照",
         "id": "3"
        ],
        ["title": "外交护照",
         "id": "4"
        ],
        ["title": "公务护照",
         "id": "5"
        ],
        ["title": "中国发无国籍旅游证件",
         "id": "6"
        ],
        ["title": "旅游通行证",
         "id": "7"
        ],
        ["title": "联合国通行证",
         "id": "8"
        ],
        ["title": "其他无国籍旅行证件",
         "id": "9"
        ],
        ["title": "其他",
         "id": "10"
        ]
    ]
    
    static let arrSex : [[String : String]] = [
        ["title": "男",
         "id": "1"
        ],
        ["title": "女",
         "id": "2"
        ]
    ]
    
    //婚姻状态
    static let arrMarry : [[String : String]] = [
        ["title": "已婚",
         "id": "1"
        ],
        ["title": "未婚",
         "id": "2"
        ],
        ["title": "离婚",
         "id": "3"
        ],
        ["title": "分居",
         "id": "4"
        ],
        ["title": "丧偶",
         "id": "5"
        ]
    ]
    
    //学位
    static let arrDegree = [
        [
            "id":"1",
            "title" : "学士学位",
        ],
        [
            "id" : "2",
            "title" : "硕士学位",
        ],
        [
            "id" : "3",
            "title" : "博士学位",
        ],
    ]
    
    //学位颁发地
    static let arrDegreeAddress = [
        [ "id": "1", "title": "国内（颁发）" ],
        [ "id": "2", "title": "国外（颁发）" ],
    ]
    
    //通过 id 获取 title
    static func getShowNameBy(indexStr:String,type : YHOtherPickerViewType) -> String {
        if indexStr.isEmpty {
            return "--"
        }
        var arrData : [[String : String]] = [[:]]
        switch type {
        case .marry:
            arrData = YHConstantArrayData.arrMarry
        case .sex:
            arrData = YHConstantArrayData.arrSex
        case .idType:
            arrData = YHConstantArrayData.arrIdType
        case .structure:
            arrData = YHConstantArrayData.arrStructure
        case .level:
            arrData = YHConstantArrayData.arrLevel
        case .degree:
            arrData = YHConstantArrayData.arrDegree
        case .degreeAddress:
            arrData = YHConstantArrayData.arrDegreeAddress
        default:
            arrData = [[:]]
        }
        
        for item in arrData {
            if let target =  item["id"],indexStr == target {
                return item["title"] ?? "--"
            }
        }
        return "--"
    }
}
