//
//  YHWholeScreenTipsView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHWholeScreenTipsViewType : Int {
    case unKnow //默认情况
    case residenceInfo //居住信息
    case degreeType //学位类型
    case company //用人单位介绍
    case officialWebsite //用人单位官网
    
    case hkPlanQ1 //赴港计划书问题1
    case hkPlanQ2 //赴港计划书问题2
    case hkPlanQ3 //赴港计划书问题3
    case hkPlanQ4 //赴港计划书问题4
    case hkPlanQ5 //赴港计划书问题5
    case hkPlanQ6 //赴港计划书问题6
}



class YHWholeScreenTipsView: UIView {
    
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = .clear
        let tap = UITapGestureRecognizer(target: self, action: #selector(dismiss))
        view.addGestureRecognizer(tap)
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hex: 0x222222, alpha: 0.9)
        view.layer.cornerRadius = kCornerRadius6
        view.clipsToBounds = true
        return view
    }()
    
    lazy var contentLable : UILabel = {
        let lable = UILabel()
        lable.text = "依日期顺序列出你自出生后曾居住12个月或更长时间的所有国家或地区，包括你的现居国家或地区"
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.textColor = .white
        lable.numberOfLines = 0
        return lable
    }()
    
    
    init(type: YHWholeScreenTipsViewType, targetView : UIView) {
        super.init(frame: UIScreen.main.bounds)
        contentLable.text = getTitleBy(type: type)
        self.createUI(targetView : targetView)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func getTitleBy(type : YHWholeScreenTipsViewType)-> String {
        switch type {
        case .residenceInfo:
            return "依日期顺序列出你自出生后曾居住12个月或更长时间的所有国家或地区，包括你的现居国家或地区"
        case .degreeType:
            return "该内容在学位证上，通常是授予后面，如授予“理学”学士学位，则填理学"
        case .company:
            return "可先填写用人单位名称，选择指定的用人单位后，系统将为您自动填写单位介绍"
        case .officialWebsite:
            return "可先填写用人单位名称，选择指定的用人单位后，系统将为您自动填写单位官网"
        case .hkPlanQ1:
            return "请以不超过100字简介你的主要事业成就，包括你在主要工作项目上曾担当的角色、你工作期间曾服务的知名机构/单位或你对有关工作项目及机构的重大贡献"
        case .hkPlanQ2:
            return "请以不超过100字简介你的专业技能或人才清单内相关专业的成就，以及有关技能/专业如何对香港经济或社会做出重大贡献"
        case .hkPlanQ3:
            return "请以不超过100字简介你的学业成就，包括你的学业成绩或曾取得的奖项（如有）"
        case .hkPlanQ4:
            return "请以不超过100字简介你未来在香港发展事业的计划，包括你与本地商业或学业机构联系及合作的详情（如有）"
        case .hkPlanQ5:
            return "请以不超过100字简介你所属的专业界别内曾获取由国家或国际认可/著名团体颁奖的专业资格，及曾取得的奖项（如有）"
        case .hkPlanQ6:
            return "请以不超过100字简介你认为对评核你的申请非常重要的其他材料"
        default:
            return "--"
        }
    }
    
    func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    static func show(type:YHWholeScreenTipsViewType, targetView : UIView) {
        let view = YHWholeScreenTipsView(type: type,targetView : targetView)
        view.show()
    }
    
    @objc func dismiss() {
        self.removeFromSuperview()
    }
    
    func createUI(targetView : UIView) {
        addSubview(blackMaskView)
        addSubview(whiteContentView)
        whiteContentView.addSubview(contentLable)
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalTo(0)
        }
        let rrrrr = targetView.convert(targetView.bounds, to: UIApplication.shared.yhKeyWindow())
        var left = rrrrr.origin.x
        let top = rrrrr.origin.y + targetView.height + 5
        
        let offset = left + 214 - KScreenWidth
        if offset > 0 {
            left = left - offset - 16
        }
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(left)
            make.top.equalToSuperview().offset(top)
            make.width.equalTo(214)
        }
        
        contentLable.snp.makeConstraints { make in
            make.top.left.equalTo(12)
            make.right.bottom.equalTo(-12)
        }
    }
}

